    if (!init_fax_scale(x_scale,y_scale,src_bytes_per_line))
        {                               /* initialize scaler */
        printf("Scale values out of range (3%% to 3200%%).\n");
        cleanup();
        exit(EXIT_BAD_SCALE);
        }
    total_lines = 0;
    do      /* main read/scale/write loop */
        {   /* note: we have split the buffer so read_pcx and write_pcx stay in lock step */
        if ((src_actual_size = read_pcx(src_scale_buffer,src_max_size)) == IO_ERROR)
            {                               /* read a buffer */
            printf("Error reading source file - %s.\n",src_file);
            cleanup();
            exit(EXIT_READ_ERROR);
            }
        dest_lines = 0;                     /* set up line counters and pointers */
        src_ptr = src_scale_buffer;
        dest_ptr = dest_scale_buffer;
        for (src_lines = src_actual_size/src_bytes_per_line ; src_lines > 0 ; src_lines--)
            {                               /* scale each source line */
            repeat = scale_fax_line(dest_ptr,src_ptr);
            dest_lines += repeat;
            while (repeat--)                /* repeat it if necessary */
                {
                if (repeat)
                    memcpy(dest_ptr+dest_bytes_per_line,dest_ptr,dest_bytes_per_line);
                dest_ptr += dest_bytes_per_line;
                }
            src_ptr += src_bytes_per_line;  /* move pointers */
            }
        assert(dest_ptr <= src_scale_buffer + SCALE_BUFFER_SIZE);
        assert(src_ptr <= dest_scale_buffer);
        if (write_pcx(dest_scale_buffer,dest_lines*dest_bytes_per_line) == IO_ERROR)
            {                               /* write out destination buffer */
            printf("Cannot write to destination file - %s.\n",dest_file);
            cleanup();
            exit(EXIT_WRITE_ERROR);
            }
        total_lines += dest_lines;
        } while (src_actual_size==src_max_size && total_lines<MAX_FAX_LENGTH);
