/************************************************
 * function: int scale_fax_line(unsigned char *dest, unsigned char *src)
 ************************************************/
int scale_fax_line(unsigned char *dest, unsigned char *src)
    {
    int y_repeat,x_repeat,i,bit;
    unsigned int accum;
    unsigned char byte;
    unsigned char *start;
    ROTATOR rotator;

    /* get line repeat value and rotate to next */
    y_repeat = y_base + (y_rotator & 0x01);
    _ror(y_rotator);
    /* if anything to do */
    if (y_repeat)
        {
        rotator = x_rotator;
        for (i=source_width, accum=1, start=dest ; i > 0 ; i--, src++)
            {       /* each byte in the source line */
            if (*src)
                {   /* if it has black bits */
                for (bit=8, byte=*src ; bit > 0 ; bit--)
                    {   /* for each bit in the byte */
                    x_repeat = x_base + (rotator & 1);
                    _ror(rotator);      /* get repeat count and rotate */
                    while (x_repeat--)
                        {               /* for each repeat */
                        accum <<= 1;    /* copy bit into accumulator */
                        accum += ((byte & 0x80) != 0);
                        if (accum & 0x100)
                            {           /* output a byte and reset sentinel */
                            *dest++ = (unsigned char) accum;
                            accum = 1;
                            }
                        }
                    byte <<= 1;
                    }
                }
            else
                {   /* no black bits, just spin it out. */
                /* how many repeats? */
                x_repeat = bit_repeat_count + ((rotator & 0xff) > bit_repeat_pattern);
                /* rotate by 8 */
                rotator = (rotator << (PRECISION-8)) | (rotator >> 8);
                /* do it */
                while (x_repeat--)
                    {
                    accum <<= 1;
                    if (accum & 0x100)
                        {
                        *dest++ = (unsigned char) accum;
                        accum = 1;
                        }
                    }
                }
            }
        if (accum > 1)
            {                       /* handle fragment */
            while ((accum & 0x100) == 0)
                accum <<= 1;
            *dest++ = (unsigned char) accum;
            }
        while (dest < start + FAX_WIDTH)
            {                       /* white out tail */
            *dest++ = 0;
            }
        }
    return y_repeat;
    }
