/************************************************
 * file: ARGS.C
 * purpose: arguments parsing and file finder
 * contains:
 *  parseargs(int argc,char *argv[],ARGS *style)
 * author: David Weber
 * history:
 *  02-15-91 - initial code
 ************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "args.h"

extern void usage(void);


/************************************************
 * function: void parseargs(int argc,char *argv[],ARGS *style)
 * parameters: argc and argv passed through from main()
 *             ARGS structure pointer telling how to parse the arguments.
 *             see args.h for an explanation and an example.
 * returns: nothing
 ************************************************/
void parseargs(int argc,char *argv[],ARGS *style)
    {
    int i,j,current_nonswitch,number_of_switches,end_of_switch;
    char *p;

    number_of_switches = strlen(style->switches);
    current_nonswitch = 0;
    for (i = 1 ; i < argc ; i++)
        {
        p = argv[i];
        if (*p == '-' || *p == '/' && style->switches != NULL)
            {   /* found a switch */
            end_of_switch = 0;
            for (p++ ; *p ; p++)
                {
                for (j = 0 ; j < number_of_switches ; j++)
                    {   /* scan switch choices */
                    if (*p == '?' || tolower(*p) == 'h')    /* help switch? */
                        {
                        usage();
                        return;
                        }
                    if (tolower(*p) == tolower(style->switches[j]))
                        {   /* got a match */
                        switch (style->formats[j])
                            {
                            case NOARG:
                                *((int *) style->switchvalues[j]) = 1;
                                break;
                            case CHARARG:
                                strncpy((char *) style->switchvalues[j],p+1,style->nonswitchsize);
                                end_of_switch = 1;
                                break;
                            case INTARG:
                                *((int *) style->switchvalues[j]) = atoi(p+1);
                                end_of_switch = 1;
                                break;
                            case LONGARG:
                                *((long *) style->switchvalues[j]) = atol(p+1);
                                end_of_switch = 1;
                                break;
                            default:
                                break;
                            }
                        break;
                        }
                    }
                if (end_of_switch)
                    break;
                if (j == number_of_switches)
                    {   /* illegal switch? */
                    usage();
                    return;
                    }
                }
            }
        else
            {   /* found a nonswitch */
            if (style->nonswitchvalues == (char **) NULL || style->nonswitchvalues[current_nonswitch] == NULL)
                {   /* enough space for nonswitches? */
                usage();
                return;
                }
            strncpy(style->nonswitchvalues[current_nonswitch],p,style->nonswitchsize);
            current_nonswitch++;
            }
        }
    }
