### polymake program generator for scale.exe, asm version

# note: the compiler is set by the environment variable C
#       which is either BORLAND, ZORTECH or MSC
# note: to create debugging info (make debug=1 -f ...)
%if %defined(debug)
DEBUG = $(debug)
%endif

# project
EXECUTABLE = scale
SOURCES = scale args pcx faxasm
OBJS = $[f,,$(SOURCES),obj]

%if $(C) == BORLAND                     # Borland Compiler
# model
MODEL = s
STARTUP = c0s
INTOBJ =
LIB = cs
# tools
CC = bcc
ASM = masm
LINK = tlink
# debug versus normal
%if %defined(DEBUG)     # debug
CFLAGS = -f- -c -v -k -N -R -m$(MODEL) -DDEBUG=1
AFLAGS = /Zi /W2 /T /MX
LFLAGS = /n /v /m /s /c
%else                   # normal
CFLAGS = -f- -c -O2 -m$(MODEL) -DNDEBUG=1
AFLAGS = /W2 /T /MX
LFLAGS = /n /P=65536 /x /c
%endif

%elseif $(C) == ZORTECH                 # Zortech compiler
# model
MODEL = si
STARTUP =
INTOBJ = int
LIB = zls
# tools
CC = ztc
ASM = masm
LINK = blinkx
# debug versus normal
%if %defined(DEBUG)     # debug
CFLAGS = -g -s -C -c -r -m$(MODEL) -DDEBUG=1
AFLAGS = /Zi /W2 /T /MX
LFLAGS = /CO /M /NOD /NOI
%else                   # normal
CFLAGS = -o -c -r -m$(MODEL) -DNDEBUG=1
AFLAGS = /W2 /T /MX
LFLAGS = /F /PAC /NOD /NOI
%endif

%elseif $(C) == MSC                     # Microsoft C compiler
# model
MODEL = S
STARTUP =
INTOBJ =
LIB = slibca
# tools
CC = cl
ASM = masm
LINK = link
# debug versus normal
%if %defined(DEBUG)     # debug
CFLAGS = /c /Zi /A$(MODEL) /DDEBUG=1
AFLAGS = /Zi /W2 /T /MX
LFLAGS =  /CO /M /NOD /NOI
%else                   # normal
CFLAGS = /c /Oatl /Gs /A$(MODEL) /DNDEBUG=1
AFLAGS = /W2 /T /MX
LFLAGS = /EXEPAC /F /PAC /NOD /NOI
%endif

%else                                   # No compiler specified
doa:
        @echo *** No compiler specified ***
        %abort 666
%endif


#rules
.asm.obj :
        $(ASM) $(AFLAGS) $<,$@;
.c.obj :
        $(CC) $(CFLAGS) $<


# ding an sich
$(EXECUTABLE).exe: $(OBJS)
   $(LINK) <@<
$(STARTUP) $(SOURCES) $(INTOBJ)
$(EXECUTABLE).exe
$(EXECUTABLE).map
$(LIB)
;
< $(LFLAGS)

#dependencies
scale.obj: scale.c args.h pcx.h faxscale.h
args.obj: args.c args.h
pcx.obj: pcx.c pcx.h
faxasm.obj: faxasm.asm faxscale.h
