/* DEMODATE.C - Demonstration application for Date Formatting. */
/* Written by: R. Scott Guthrie                                */
/* Requires XLATE functions and translate file entries for     */
/*  "Month Position", "Day Position", "Year Position", and     */
/*  "Date Format".                                             */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xlate.h"

/**** DateFormatter *********************************************/
/* Function to build date string based on XLATE file definition */
/* using passed in date values.  Returns the date string.       */
/* Requires translate file line entries of:                     */
/*  "Month Position", "Day Position", "Year Position", and      */
/*  "Date Format".                                              */
/****************************************************************/
void DateFormatter(char *Date, int Day, int Month, int Year)
{
  char order[3];    /* Holds the display order of M, D, Y */
  int  value[3];    /* Holds the date value in desired order */
  char format[15];  /* Holds the date format string */
  int  i;           /* index variable */
  int  temp;        /* temporary integer */

  /* Get the Display Order information */
  order[atoi(Xlate("Day Position"))]   = 'D';
  order[atoi(Xlate("Month Position"))] = 'M';
  order[atoi(Xlate("Year Position"))]  = 'Y';

  /* Get the Format Definition */
  strcpy(format, Xlate("Date Format"));

  /* Establish date component order */
  for(i=0; i<3; i++)
  {
    switch(order[i])
    {
      case 'M':
        temp = Month;
        break;
      case 'D':
        temp = Day;
        break;
      case 'Y':
        temp = Year;
        break;
      default :
        break;
    }
    value[i] = temp;  /* store date values in desired order */
  }

  /* Create the date string */
  sprintf(Date, format, value[0], value[1], value[2]);

  return;
}

void main()
{
  int iDay = 23;      /* Define a DAY value */
  int iMonth = 4;     /* Define a Month value */
  int iYear = 93;     /* Define a YEAR value */
  char date[12];      /* Formatted date is placed in this string */

  /* Show current date values */
  printf("Given a DAY value of %d, ", iDay);
  printf("a MONTH value of %d, ", iMonth);
  printf("and a YEAR value of %d:\n", iYear);

  /* Establish AMERICAN date format (as described in AMERICAN.TRN) */
  XlateSet("AMERICAN");

  /* Format the Date String according to XLATE file information */
  DateFormatter(date, iDay, iMonth, iYear);
  printf("%s is America's Format.\n", date);

  /* Establish ENGLISH date format (as described in ENGLAND.TRN) */
  /* Note: 'XlateSet()' removes the existing table */
  XlateSet("ENGLAND");

  /* Print the Date String formatted by 'DateFormatter' */
  DateFormatter(date, iDay, iMonth, iYear);
  printf("%s is England's Format.\n", date);

  /* Establish an alternate date format (as described in ALTDATE.TRN) */
  XlateSet("ALTDATE");

  /* Print the Date String formatted by 'DateFormatter' */
  DateFormatter(date, iDay, iMonth, iYear);
  printf("%s as an Alternate Format.\n", date);

  /* Free ALTDATE Translate Table memory */
  XlateFree();
}
/* end source file DEMODATE.C */
