/* File: MENU.C     R. Scott Guthrie            */
/* This sample application demonstrates the     */
/* functionality provided by the XLATE routines */
/* in determining text messages at run time.    */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xlate.h"

/******************************************/
/* Present a selection menu for the user, */
/* and obtain a valid input.              */
/******************************************/
int menu_selection(char *menu)
{
  /* Returns 0 if quitting, 1 if */
  /* a valid selection is made.  */ 
  int user_entry;  /* entered option */
  int retval = 1;  /* return value   */
    
  /* Display the selection menu. */
  do
  {
    printf("Meal Selection:\n\n");
    printf("  1) Breakfast\n");
    printf("  2) Lunch\n");
    printf("  3) Dinner\n");
    printf("  4) Snack\n");
    printf("  Q) to quit\n");
    printf("\nEnter MENU Desired: ");

    /* Get user input */
    user_entry = getchar();
    /* (Eat the return associated with the input) */
    (void) getchar();
  }	  
  /* Validate user's input */
  while ((strchr("1234qQ", user_entry) == 0));

  /* Turn user's selection into Translate File name */
  switch (user_entry)
  {
    case '1' :
      strcpy(menu, "B_FAST");
      break;
    case '2' :
      strcpy(menu, "LUNCH");
      break;
    case '3' :
      strcpy(menu, "DINNER");
      break;
    case '4' :
      strcpy(menu, "SNACK");
      break;
    default:
      retval = 0;  /* quitting */
      break;
  }  /* end switch */

  return (retval);
}  /* end function 'menu_selection' */
    
/******************************************/
/* Application MAIN                       */
/* This example application demonstrates  */
/* the usage of the translate routines.   */
/******************************************/
void main()
{
  char menu[14];   /* Translate File name */

  while(menu_selection(menu))
  {
    XlateSet(menu);
    printf("You have selected the %s menu.\n", Xlate("meal"));
	printf("Items from this menu are available\n");
	printf("%s.\n\n", Xlate("hours"));
    printf("Offerings available are:\n");
	printf("    %s\n", Xlate("Main Course"));
	printf("    %s\n", Xlate("Side Dish"));
	printf("    %s\n", Xlate("Beverage"));
	printf("\n----------------------------------------\n");
  }  /* end while */

  XlateFree();  /* free translate table memory */
  printf("MENU PROGRAM COMPLETE\n");

} /* end main */
/* end source file 'menu.c' */
