Listing 6 - a template class for a wrapper around a genq

//
// queue11.h - a class template for a generic queue
// implemented as a wrapper around a genq
//

#include "genq7.h"

//
// the "declare" part
//
template <class T>
class queue
    {
public:
    queue();
    ~queue();
    void append(const T &e);
    void clear();
    int remove(T &e);
    class iterator;
    friend class iterator;
    class iterator
        {
    public:
        iterator(queue<T> &q) : gqi(q.gq) { }
        T *next() { return (T *)gqi.next(); }
    private:
        genq::iterator gqi;
        };
private:
    genq gq;
    };

template <class T>
inline queue<T>::queue()
    {
    }

template <class T>
inline queue<T>::~queue()
    {
    clear();
    }

template <class T>
inline void queue<T>::append(const T &e)
    {
    gq.append(new T(e));
    }

//
// the "implement" part
//
template <class T>
void queue<T>::clear()
    {
    void *p;
    while (gq.remove(p))
        delete (T *)p;
    }

template <class T>
int queue<T>::remove(T &e)
    {
    void *p;
    int rv = gq.remove(p);
    if (rv)
        {
        e = *(T *)p;
        delete (T *)p;
        }
    return rv;
    }


