//file: BitArr.cpp--------------------
#include "BitArr.h"

ostream& operator<<(ostream& os, const BitArray & bv){
  for(int ii = bv.first(); ii<=bv.last(); ii++){
    os << bv[ii] << " ";
  }
  return os;
}

BitArray reverse(const BitArray& src){
  BitArray result(src);
  for(int ii = src.first(); ii<= src.last(); ii++)
    result[src.last()-ii] = src[ii];
  return result;
}

struct X{
  X(unsigned long x){
    cout<<"create X, x = "<<hex<<x;
  }
};
void f(const X&){
  cout<<" Fuction f"<<endl;
}

main(){
  cout << "begin"<<endl;

  BitArray x(1, 0x8aaa71b5ul);
  cout << reverse(x) << endl;
  x[3] = x[2] = x[1] = 1;
  cout << reverse(x) <<endl;

  const BitArray xx = x;
  f(xx[1]);

  BitArray y(4, 0x8aaa71b5ul);
  cout << reverse(y) << endl;
  y[7]=13;
  y[1]=15;
  cout << reverse(y) << endl;

  BitArray z(16, 0x8aaa71b5ul);
  cout << reverse(z) << endl;
  z[1]=15;
  cout << reverse(z) << endl;

  return 0; } 

