/* DYN2DARR.H */

#ifndef DYN2DARR
#define DYN2DARR

#include <stdlib.h> /* for free() */

/* private macros */
#define Dyn2dRndUp(i,j)  ((1 + (i-1)/(j)) * (j)) 
#define Dyn2dRndDown(i,j) (((i)/(j)) * (j))
#define Dyn2dColOff(A)   (Dyn2dRndDown( (char *) A[0] - (char *) A,\
              sizeof(unsigned)) - sizeof (unsigned))
#define Dyn2dRowOff(A)   (Dyn2dColOff(A) - sizeof (unsigned))

/* public macros */
#define Dyn2dArray(r,c,t) (dyn2darray((unsigned) (r), \
             (unsigned) (c), sizeof(t) ))
#define Dyn2dRows(A)    (*(unsigned *) ((char *)(A) + Dyn2dRowOff(A)))
#define Dyn2dCols(A)    (*(unsigned *) ((char *)(A) + Dyn2dColOff(A)))

#if 0
/* Might not be what you need. */
#define Dyn2dSizeOf(A) ( Dyn2dRows(A) * Dyn2dCols(A) * sizeof( **A) )

#endif

/* Prototype */
void **dyn2darray( unsigned row, unsigned col, unsigned el_size);

#endif

/* End of File */
