/********************************************
 * Generate a header file with freqency
 * distribution obtained from specified
 * file
 *
 * 1993 by Erick Otto
 ********************************************/
#include <stdio.h>

main(argc,argv)
int argc;
char *argv[];
{

    FILE *iptr,*optr;
    int dist[256];
    int c;
    int i;
    int total;

    for (i=0;i<256;i++) dist[i] =0;
    total=0;

    if (argc < 3) {
	fprintf(stderr,"Not enough arguments\n");
	fprintf(stderr,"%s infile outfile\n",argv[0]);
	exit(1);
    }

    if ((iptr = fopen(argv[1],"r")) == NULL) {
        fprintf(stderr,
           "Can not open file %s\n",argv[1]);
    }
    if ((optr = fopen(argv[2],"w")) == NULL) {
        fprintf(stderr,
           "Can not open file %s\n",argv[2]);
    }

    while ((c = getc(iptr)) != EOF) {
        total++;
        dist[c]++;
    }

    fprintf(optr,"double freq[256] = { /* From %s */\n",
       argv[1]);

    for (i=0;i<256;i++) {

        fprintf(optr,"%G, ",(double)dist[i]/(double)total);

	if (i !=0 && (i % 4) == 0)  fprintf(optr,"\n");
    }
    fprintf(optr,"};\n");
}


