/* BAZ.C
 * Contributed to Public Domain 9/93
 * by Thad Smith, Boulder Co.
 */
#include <stdio.h>
#include <stdlib.h>
#include "baz.h"

#define MAX_COL     70  /* # output chars / line */

FILE       *inf, *outf;
unsigned char buf[8192];

/* Write data block to output file. */
/* ret value: 0 = OK, -1 = error    */
int
enc_out (const char *out, size_t len)
{
   fwrite ((const void *) out, 1, len, outf);
   return (ferror (outf) ? -1 : 0);
}

int
main (int argc, char *argv[])
{
   unsigned int n;      /* # bytes read          */
   int         s;       /* return output status  */

   if (argc != 3) {
      puts ("BAZ - Convert binary file to "
            "BAZ911-encoded file");
      puts ("Usage: BAZ infile outfile");          
      puts ("  infile = input file (any format)");
      puts ("  outfile= output file in BAZ911 format");
      return EXIT_FAILURE;
   }
   if ((inf = fopen (argv[1], "rb")) == NULL) {
      fprintf (stderr, "Error opening input file: %s",
                        argv[1]);
      return EXIT_FAILURE;
   }
   if ((outf = fopen (argv[2], "w")) == NULL) {
      fprintf (stderr, "Error opening output file: %s",
                        argv[2]);
      return EXIT_FAILURE;
   }
   fprintf (outf, "BAZ911: %s\n", argv[1]);
   ebaz_init (MAX_COL, enc_out);
   do {
      n = fread (buf, 1, sizeof buf, inf);
      s = ebaz_data (buf, n);
   } while (n > 0 && s == 0);
   putc ('\n', outf);
   if (ferror (outf)) {
      fprintf (stderr, "Error writing output file\n");
      return EXIT_FAILURE;
   }

   if (ferror (inf)) {
      fprintf (stderr, "Error reading input file\n");
      return EXIT_FAILURE;
   }
   return EXIT_SUCCESS;
}
/* End of File */ 

