/* CRC16.H
 *
 * Use updcrc() for a block of data,
 *   UPDATE_CRC1() for a single byte.
 *
 * Adapted from CRC-16F.C, a public domain routine
 * in Bob Stout's Snippets file collection.
 * Adaptations donated to public domain.
*/

#define CRCW 16             /* # bits in CRC */
#define CRCLBY  (CRCW/8)    /* CRC byte length */
#define CRCMASK ((1U<<CRCW)-1) /* mask for full CRC */

extern unsigned short crctab[1 << 8];

void initcrctab(void);  /* Initialize CRC table */
unsigned short updcrc(unsigned short icrc,
    const unsigned char *icp, unsigned int icnt);

#define UPDATE_CRC1(c,crc) (((crc)<<8) ^ \
        crctab[(((crc)>>(CRCW-8)) ^ (c)) & 0xff])

/* End of File */ 

