Listing 1 - class definitions for a queue of int using a non-nested cell 
type

//
// intq1.h - a queue of int (interface)
//

#include <iostream.h>

class intq_cell
	{
	friend class intq;
private:
	intq_cell(const int &e, intq_cell *p);
	intq_cell *next;
	int element;
	};

inline intq_cell::intq_cell(const int &e, intq_cell *p)
	: element(e), next(p)
	{
	}

class intq
	{
public:
	intq();
	~intq();
	void append(const int &e);
	void clear();
	void print(ostream &os) const;
	int remove(int &e);
private:
	intq_cell *first, *last;
	};

inline intq::intq() : first(0), last(0)
	{
	}

inline intq::~intq()
	{
	clear();
	}

