
'C'  Declaration Code for Rule Table and Membership Functions

/**********************************************************************
	File: fuzzy.h
	Date: 4/3/93
	Author: Jack J. McCauley
	Header file for fuzzy.c
**********************************************************************/

/* membership function size */
#define TORQUE_MEMBERS  5
#define DER_MEMBERS  5

/* loop frequency */
#define LOOP_HZ 1

/* integrator constant z-1*/
#define SKIP 1

/* normalized value */
#define NORMAL 255

/* Current ma */
#define MAX_TORQUE 1000
#define MIN_TORQUE -1000

/* derivative */
#define MAX_DERI LOOP_HZ*MAX_TORQUE
#define MIN_DERI LOOP_HZ*MIN_TORQUE

/* pwm 1/10 % */
#define MAX_PWM   255
#define MIN_PWM   0

/* Max and Min */
#define MIN_ERROR   0
#define MAX_ERROR   255

/* size of all arrays */
#define ARRAY_SIZE   256

/* represent a normalized 0 -> 1000 = 0.0 -> 1.0 */
#define FUZZY_RADIX  NORMAL

/* fuzzy max (ternary) operator */
#define FUZ_MAX( x, y )    ((x>y) ? x : y)

/* fuzzy min (ternary) operator */
#define FUZ_MIN( x, y )    ((x<y) ? x : y)

/* fuzzy AND operator */
#define FUZ_AND( x, y )    FUZ_MIN( x, y )

/* fuzzy OR operator */
#define FUZ_OR( x, y )     FUZ_MAX( x, y )

/* fuzzy compliment operator */
#define FUZ_NOT( x )       ( FUZZY_RADIX - x )

/* create the membership function space */
/* first is the torque error  fuzzy set */
struct  s_torq_members {
	int neg_large[ARRAY_SIZE];
	int neg_med[ARRAY_SIZE];
	int zero[ARRAY_SIZE];
	int pos_med[ARRAY_SIZE];
	int pos_large[ARRAY_SIZE];
	float slope;
	float intercept;
}  torq_members;

/* next is the rate of change fuzzy set torque error */
struct  s_deri_members {
	int pos_large[ARRAY_SIZE];
	int pos_med[ARRAY_SIZE];
	int zero[ARRAY_SIZE];
	int neg_med[ARRAY_SIZE];
	int neg_large[ARRAY_SIZE];
	float slope;
	float intercept;
} deri_members;

/* last is the PWM fuzzy set ouput */
struct  s_pwm_members {
	int neg_large[ARRAY_SIZE];
	int neg_med[ARRAY_SIZE];
	int zero[ARRAY_SIZE];
	int pos_med[ARRAY_SIZE];
	int pos_large[ARRAY_SIZE];
	float slope;
	float intercept;
} pwm_members;

/* define output rule table members */
#define L            pwm_members.pos_large
#define M            pwm_members.pos_med
#define Z            pwm_members.zero
#define NM           pwm_members.neg_med
#define NL           pwm_members.neg_large

/* finally the fuzzy sets */
/* torque feedback error */
int *dTerr_dt[] = {
		 deri_members.pos_large  ,
		 deri_members.pos_med    ,
		 deri_members.zero       ,
		 deri_members.neg_med    ,
		 deri_members.neg_large
		 };
/* torque (OZ-in) */
int *Terror[] = {
		 torq_members.neg_large  ,
		 torq_members.neg_med    ,
		 torq_members.zero       ,
		 torq_members.pos_med    ,
		 torq_members.pos_large
		 };

/* create the rule table and allocate space */
struct  s_rule {
	int *table[TORQUE_MEMBERS];
} rule[DER_MEMBERS] =
	/* */
	{{Z,   NM, NM, NM,  NL },
	{ M,   Z,  NM, NM,  NL },
	{ L,   M,  Z,  NM,  NL },
	{ L,   M,  M,  Z,   NM  },
	{ L,   M,  M,  M,   Z  }};

