/* LISTING 1 */
/* parsdef.h */
/* No copyrights claimed */
#define ERROR               1
#define EMPTY               2
#define ASSIGN              3
#define REQUEST             4
#define TO_EEPROM           5
#define IS                  6
#define COMMAND             7
#define INTEGER             8
#define NAME                10
#define NAME_ERROR          11
#define OP_ERROR            12
#define VAL_ERROR           13
#define END_ERROR           14
#define POOL_ERROR          15
#define UNDEF_SYMB          16
#define NOT_EEPROM          17
#define UNDEF_FUNC          18
#define MAX_TOKEN_LEN       10
#define MAX_STATEMENTS      20
#define STRINGPOOL          80
#define MESSAGELENGTH       80

typedef struct {
    int command;
    int type;
    char *name;
    int  value;
} toDoList;

typedef struct {
    char *name;
    int ival;
    char *(*func)(char *);
    int eeOffset;    /* -1 if not saved in eeprom */
} symTabEntry;

char        *Assign(toDoList *pL, char *pTx);
void         DoCommands(toDoList *pL);
symTabEntry *FindSymbol(char *name);
char        *GetNextToken(char *begin, char *token, int *type);
void         Parse(char *message, toDoList *pL);
void         PrintToDo(toDoList *toDo);
char        *Request(toDoList *pL, char *pTx);
char        *Reset(char *ptr);
char        *RunCommand(toDoList *pL, char *pTx);
char        *SayError(toDoList *pL, int err, char *cp);
int          StoreToken(char **strp, char *token);
int          SymCmp(symTabEntry *a, symTabEntry *b);
char        *ToEeprom(toDoList *pL, char *pTx);
char        *TxBuffer(void);
void         WriteEeprom(symTabEntry *pSym, int type);
