
Listing 3.  Vector and TempVector with dynamic VES 
class TempVector;
class Vector             // Vector class definition
{    unsigned lng;            // Vector Length
     double *ves;             // Vector Element Space
 public:
     friend TempVector;
     Vector ()                     // Default Constructor
     {    lng = 0;                 // No VES
          ves = NULL; }
     Vector (const unsigned ln)    // New Vector Constructor
     {    lng = ln;                // Set length
          ves = new double [ln]; } // Create new VES
     Vector (const Vector& v) // Copy Constructor
     {    lng = v.lng;             // Set length
          ves = new double [lng];       // Create new VES
          memcpy (ves, v.ves, lng * sizeof(double)); }
     Vector (TempVector&);         // Typecast "Copy" Constructor
     ~Vector () { if (ves != NULL) delete ves; } // Destructor
     double& operator()(const int coordinate) const
     {    // Address elements by coordinate
          return ves[coordinate]; }
     unsigned length() const { return lng; } // Report Vector length
     Vector& operator= (const Vector& v);    // Assignment operator
     Vector& operator= (TempVector& v);      // Assignement operator
     TempVector operator+ (const Vector&) const;  // Vector Addition
     TempVector operator+ (const TempVector&) const;   // Vector Addition
     friend TempVector unit (const Vector&); // Unitize Vector
};
class TempVector              // Temporary Vector class definition
{    unsigned lng;            // Vector Length
     double *ves;             // Vector Element Space
   friend Vector;
     TempVector ()            // Default Constructor
     {    lng = 0;                 // No VES
          ves = NULL; }
     TempVector (const unsigned ln) // New TempVector Constructor
     {    lng = ln;                // Set length
          ves = new double [ln]; } // Allocate new VES
     TempVector (TempVector& v)    // Copy Constructor
     {    lng = v.lng;             // Set length
          ves = v.ves;             // Seize VES 
          v.ves = NULL; }
     unsigned length() const { return lng; } // Report Vector length
  public:
     ~TempVector () { if (ves != NULL) delete ves; } // Destructor
     double& operator()(const int coordinate) const
     {    // Address elements by coordinate
          return ves[coordinate]; }
     friend TempVector unit (const Vector&)  // Unitize Vector
     friend TempVector unit (const TempVector&); // Unitize Vector
     // No assignment operator
     friend Vector::Vector (TempVector&);
     TempVector operator+ (const Vector&) const; // Vector Addition
     TempVector operator+ (const TempVector&) const; // Vector Addition
     friend TempVector Vector::operator+ (const TempVector&);
};
Vector::Vector (TempVector& v)
{    // Typecast "Copy" Constructor from TempVector to Vector
     ves = v.ves;             // Seize VES
     v.ves = NULL;
     lng = v.lng; }           // Set Vector length

Vector& Vector::operator= (const Vector& v)
{    // Assignment operator
     if (ves != v.ves) {      // Protect against self-reference
          if (ves != NULL) delete ves;  // Delete VES, if any
          lng = v.lng;             // Set Vector length
          ves = new double [lng];       // Allocate new VES & copy
          memcpy (ves, v.ves, lng * sizeof(double)); }
     return *this; }
Vector& Vector::operator= (TempVector& v)
{    // Assignment operator
     // No danger of self-reference
     if (ves != NULL) delete ves;  // Delete VES, if any
     lng = v.lng;             // Set Vector length
     ves = v.ves;             // Seize VES
     v.ves = NULL;
     return *this; }

TempVector Vector::operator+ (const Vector& v) const
{    // Vector addition
     if (v.lng != lng) exit(1);    // Ensure conformal addition
     TempVector u (lng);      // Create same size Vector
     for (int i = 0; i < lng; i++) // Carry out addition
          u.ves[i] = ves[i] + v.ves[i];
     return u; }
TempVector Vector::operator+ (const TempVector& v) const
{    // Vector addition
     if (v.lng != lng) exit(1);    // Ensure conformal addition
     TempVector u (lng);      // Create same size Vector
     for (int i = 0; i < lng; i++) // Carry out addition
          u.ves[i] = ves[i] + v.ves[i];
     return u; }
TempVector TempVector::operator+ (const Vector& v) const
{    // Vector addition
     if (v.lng != lng) exit(1);    // Ensure conformal addition
     TempVector u (lng);      // Create same size Vector
     for (int i = 0; i < lng; i++) // Carry out addition
          u.ves[i] = ves[i] + v.ves[i];
     return u; }
TempVector TempVector::operator+ (const TempVector& v) const
{    // Vector addition
     if (v.lng != lng) exit(1);    // Ensure conformal addition
     TempVector u (lng);      // Create same size Vector
     for (int i = 0; i < lng; i++) // Carry out addition
          u.ves[i] = ves[i] + v.ves[i];
     return u; }


