LISTING 9 - Implements cursor control for the IBM PC
// cursor.cpp

#include <dos.h>
#include "cursor.h"
#include "video.h"

int Cursor::state = Cursor::init();

int Cursor::init()
{
    // Start with a line cursor
    line();
    return LINE;
}

void Cursor::set(unsigned start, unsigned stop)
{
    union REGS r;
    
    // Set vertical size of cursor block
    r.h.ah = 1;
    r.h.ch = (unsigned char) start;
    r.h.cl = (unsigned char) stop;
    int86(0x10,&r,&r);
}

void Cursor::block()
{
    // Make the cursor a full rectangle
    switch(Video::type())
    {
    case Video::COLOR:
        set(2,7);
        break;
    
    case Video::MONO:
        set(2,13);
        break;
    }
    state = BLOCK;
}

void Cursor::line()
{
    // Make the cursor a thin line
    switch(Video::type())
    {
    case Video::COLOR:
        set(6,7);
        break;
    
    case Video::MONO:
        set(12,13);
        break;
    }
    state = LINE;
}

void Cursor::flip()
{
    // Toggle between a block and line cursor
    state = !state;

    switch(state)
    {
    case LINE:
        line();
        break;
        
    case BLOCK:
        block();
        break;
    }
}

void Cursor::off()
{
    // Make the cursor invisible
    set(15,0);
}

void Cursor::setpos(int row, int col)
{
   union REGS r;
   
    // Set the cursor position
   r.x.ax = 0x0200;
   r.x.bx = 0;
   r.h.dh = (unsigned char) row;
   r.h.dl = (unsigned char) col;
   int86(0x10,&r,&r);
}

void Cursor::getpos(int& row, int& col)
{
   union REGS r;

    // Read the cursor position
   r.x.ax = 0x0300;
   r.x.bx = 0;
   int86(0x10,&r,&r);
   row = r.h.dh;
   col = r.h.dl;
}

