
LISTING 3 -
// date.cpp

#include <iostream.h>
#include <assert.h>
#include "time.h"
#include "date.h"

// Must define static members at file scope:
int Date::dtab[2][13] =
{
  {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
  {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

int Date::month(int m)
{
    // Change month
    int old_month = month_;
    if (m >= 1 && m <= 12)
        month_ = m;
    return old_month;
}

int Date::day(int d)
{
    // Change day
    int old_day = day_;
    if (d >= 1 && d <= dtab[isleap(year_)][month_])
        day_ = d;
    return old_day;
}

int Date::year(int y)
{
    // Change year
    int old_year = year_;
    year_ = y;
    return old_year;
}

int Date::compare(const Date& d1, const Date& d2)
{
    int months, days, years, order;

    years = d1.year_ - d2.year_;
    months = d1.month_ - d2.month_;
    days = d1.day_ - d2.day_;

    // return <0, 0, or >0, like strcmp()
    if (years == 0 && months == 0 && days == 0)
        return 0;
    else if (years == 0 && months == 0)
        return days;
    else if (years == 0)
        return months;
    else
        return years;
}

ostream& operator<<(ostream& os, const Date& d)
{
    os << d.month_ << '/' << d.day_ << '/' << d.year_;
    return os;
}

istream& operator>>(istream& is, Date& d)
{
    char slash;
    is >> d.month_ >> slash >> d.day_ >> slash >> d.year_;
    return is;
}

Date::Date()
{
    // Get today's date
    time_t tval = ::time(0);
    struct tm *tmp = ::localtime(&tval);

    month_ = tmp->tm_mon+1;
    day_ = tmp->tm_mday;
    year_ = tmp->tm_year + 1900;
}

