LISTING 14 - Adds implementation to complete the Cursor namespace
// cursor.cpp

#include <dos.h>
#include "cursor.h"
#include "video.h"


namespace Cursor
{
    int state = init();

    int init()
    {
        // Start with a line cursor
        line();
        return LINE;
    }

    void set(unsigned start, unsigned stop)
    {
        union REGS r;

        r.h.ah = 1;
        r.h.ch = (unsigned char) start;
        r.h.cl = (unsigned char) stop;
        int86(0x10,&r,&r);
    }

    void block()
    {
        switch(Video::type())
        {
        case Video::COLOR:
            set(2,7);
            break;

        case Video::MONO:
            set(2,13);
            break;
        }
        state = BLOCK;
    }

    void line()
    {
        switch(Video::type())
        {
        case Video::COLOR:
            set(6,7);
            break;

        case Video::MONO:
            set(12,13);
            break;
        }
        state = LINE;
    }

    void flip()
    {
        state = !state;

        switch(state)
        {
        case LINE:
            line();
            break;

        case BLOCK:
            block();
            break;
        }
    }

    void off()
    {
        set(15,0);
    }

    void setpos(int row, int col)
    {
        union REGS r;

        r.x.ax = 0x0200;
        r.x.bx = 0;
        r.h.dh = (unsigned char) row;
        r.h.dl = (unsigned char) col;
        int86(0x10,&r,&r);
    }

    void getpos(int& row, int& col)
    {
        union REGS r;

        r.x.ax = 0x0300;
        r.x.bx = 0;
        int86(0x10,&r,&r);
        row = r.h.dh;
        col = r.h.dl;
    }
}

