Listing 4.

/* errmgr.hpp fragment */

class error_mgr {
    public:
        error_mgr(void);
        ~error_mgr(void);
        int define_dictionary(const char *filename);

        /* returns handler just hidden */
        failure_handler *define_handler(
                failure_handler *new_handler);
        /* returns handler just popped */
        failure_handler *restore_handler(void);

        void fail(const char *fmt,...);
        void vfail(const char *fmt,va_list ap);
        void error(const char *fmt,...);
        void verror(const char *fmt,va_list ap);
        void warn(const char *fmt,...);
        void vwarn(const char *fmt,va_list ap);
        void post(const char *fmt,...);
        void vpost(const char *fmt,va_list ap);

        const char *message(const char *fmt,
                            char *msg_line,int len);

        int set_assert_flag(int asserts_on);
        static int assertions_off(void)
            { return asserts_off; }
        int assert_failed(
            const char *exp,const char *fname,
            unsigned linenum);
    private:
        void setup(void);
        static failure_handler *curr_handler,
                               *default_handler;
        static int is_set_up,asserts_off;
        static error_dict_list *error_dicts;
        static ptr_stack *handler_stack;
        int find_replacement(
            const char *key,char *msg_line,
            int linelen);
        /* unimplemented: */
        error_mgr(const error_mgr &other);
        error_mgr &operator =(const error_mgr &other);
};

extern error_mgr err_mgr;

#define ASSERT(e) \
    ((void)(err_mgr.assertions_off() || \
     (e) || \
     err_mgr.assert_failed(#e,__FILE__,__LINE__)))
