/* c_failur.cpp - counting_failure_handler implementation */

/* this is pretty simple stuff - it installs itself into the handler */
/* chain when it's allocated and removes itself when deleted. along */
/* the way it counts error() and warning() messages before passing */
/* them along to the previous handler, which actually prints them. */

#include "utils.hpp"
#include "errmgr.hpp"
#include "c_failur.hpp"

counting_failure_handler::counting_failure_handler(void)
{
    /* install ourselves as the current handler when we are created. */

    error_logged = warn_logged = 0L;
    prev_handler = err_mgr.define_handler(this);

}  /* end of counting_failure_handler::counting_failure_handler() */

counting_failure_handler::~counting_failure_handler(void)
{
    /* unlink ourselves from the handler chain when we are destroyed. */
    /* ensure no other handler is stacked over us! */

    failure_handler *top;

    top = err_mgr.restore_handler();
    ASSERT(top == this);

}  /* end of counting_failure_handler::~counting_failure_handler() */

void counting_failure_handler::fail(const char *fmt,va_list ap)
{
    prev_handler->fail(fmt,ap);         /* just pass it on - we'll exit soon */

}  /* end of counting_failure_handler::fail() */

void counting_failure_handler::error(const char *fmt,va_list ap)
{
    ++error_logged;                     /* tally problems */
    prev_handler->error(fmt,ap);        /* pass the message on */

}  /* end of counting_failure_handler::error() */

void counting_failure_handler::warn(const char *fmt,va_list ap)
{
    ++warn_logged;                      /* tally problems */
    prev_handler->warn(fmt,ap);         /* pass the message on */

}  /* end of counting_failure_handler::warn() */

void counting_failure_handler::post(const char *fmt,va_list ap)
{
    prev_handler->post(fmt,ap);         /* pass the message on */

}  /* end of counting_failure_handler::post() */
