/* c_failur.hpp - counting_failure_handler */

/* counting_failure_handler is a dummy handler which merely counts the */
/* number of errors and warnings (failures can't return!) and returns */
/* them to the caller. the messages are still printed, of course. it's */
/* handy for the times when errors are reported in an object's constructor */
/* (which has no return value). note that assertion failures count as */
/* errors! */

/* the assumption, of course, is that no other handler will be installed */
/* while the counting handler is in operation. otherwise it's at the mercy */
/* of the handler on top of it! */

/* a counting_failure_handler will install itself in the handler stack; */
/* no need to call err_mgr.define_handler() after creating one. conversely, */
/* it will remove itself from the handler stack when it is destroyed. */

/* the destructor is virtual per section 12.4 of the 1990 ARM. */

#ifndef C_FAILUR_HPP
#define C_FAILUR_HPP

#include "errmgr.hpp"                   /* failure_handler */

class counting_failure_handler : public failure_handler {
    public:
        counting_failure_handler(void);  /* install self in handler stack */
        virtual ~counting_failure_handler(void);  /* remove self from stack */
        virtual void fail(const char *fmt,va_list ap);  /* pass it on */
        virtual void error(const char *fmt,va_list ap);  /* count, pass it */
        virtual void warn(const char *fmt,va_list ap);   /* count, pass it */
        virtual void post(const char *fmt,va_list ap);   /* not counted */
        unsigned long errors_logged(void) { return error_logged; }
        unsigned long warns_logged(void) { return warn_logged; }
    private:
        unsigned long error_logged,warn_logged;
        failure_handler *prev_handler;
};  /* end of class counting_failure_handler() */

#endif  /* C_FAILUR_HPP */
