/* tstassrt.cpp - test program for assertions */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "errmgr.hpp"                   /* ASSERT() */


int main(int argc,char *argv[])
{
    /* this program should be run three times - once with assertions off, */
    /* once to get past the assertions (allow execution to continue), and */
    /* once to fail them. */

    char *s = "hello!";
    char buf[80];

    /* turn assertions off if the user so desires. */

    printf("Turn assertions off [no]? ");
    fgets(buf,sizeof(buf),stdin);
    err_mgr.set_assert_flag(toupper(*buf) != 'Y');

    ASSERT(strcmp("hello",s));          /* string constants in assertions? */
    ASSERT(!strcmp("hello",s));
    ASSERT(1 == 2);                     /* had better fail! */
    fputs("got past assertion\n",stderr);
    return EXIT_SUCCESS;

}  /* end of main() */

