
     /*******************************************
     *
     *   arotate(..
     *
     *   This routine performs rotation about
     *   any point m,n.
     *
     *   The basic equations are:
     *
     *   new x = x.cos(a) - y.sin(a)
     *           -m.cos(a) + m + n.sin(a)
     *
     *   new y = y.cos(a) + x.sin(a)
     *           -m.sin(a) - n.cos(a) + n
     *
     *******************************************/

arotate(in_name, out_name, the_image, out_image,
        il, ie, ll, le, angle,
        m, n, bilinear)
   char   in_name[], out_name[];
   float  angle;
   int    bilinear, il, ie, ll, le;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS],
          m, n;
{
   double cosa, sina, radian_angle, tmpx, tmpy;
   int    i, j, new_i, new_j;
   struct tiff_header_struct image_header;

   create_file_if_needed(in_name, out_name, out_image);

   read_tiff_image(in_name, the_image, il, ie, ll, le);


      /* the following magic number is from
         180 degrees divided by pi */
   radian_angle = angle/57.29577951;
   cosa  = cos(radian_angle);
   sina  = sin(radian_angle);

      /**************************
      *
      *   Loop over image array
      *
      **************************/

   printf("\n");
   for(i=0; i<ROWS; i++){
      if( (i%10) == 0) printf("%d ", i);
      for(j=0; j<COLS; j++){

     /******************************************
     *
     *   new x = x.cos(a) - y.sin(a)
     *           -m.cos(a) + m + n.sin(a)
     *
     *   new y = y.cos(a) + x.sin(a)
     *           -m.sin(a) - n.cos(a) + n
     *
     *******************************************/

         tmpx = (double)(j)*cosa    -
                (double)(i)*sina    -
                (double)(m)*cosa    +
                (double)(m)         +
                (double)(n)*sina;

         tmpy = (double)(i)*cosa    +
                (double)(j)*sina    -
                (double)(m)*sina    -
                (double)(n)*cosa    +
                (double)(n);

         new_j = tmpx;
         new_i = tmpy;

         if(bilinear == 0){
            if(new_j < 0       ||
               new_j >= COLS   ||
               new_i < 0       ||
               new_i >= ROWS)
               out_image[i][j] = FILL;
            else
               out_image[i][j] =
                the_image[new_i][new_j];
         }  /* ends if bilinear */
         else{
            out_image[i][j] = 
               bilinear_interpolate(the_image,
                                    tmpx, tmpy);
         }  /* ends bilinear if */

      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il, ie, ll, le);

}  /* ends arotate */
