

   /***********************************************
   *
   *       file d:\cips\addsub.c
   *
   *       Functions: This file contains
   *          add_image_array
   *          subtract_image_array
   *
   *       Purpose:
   *          These functions implement
   *          image addition and subtraction.
   *
   *       External Calls:
   *          wtiff.c - round_off_image_size
   *                    create_file_if_needed
   *                    write_array_into_tiff_image
   *          tiff.c - read_tiff_header
   *          rtiff.c - read_tiff_image
   *
   *
   *       Modifications:
   *          1 April 1992 - created
   *
   *************************************************/

#include "cips.h"

     /*******************************************
     *
     *   add_image_array(...
     *
     *   This function adds two ROWSxCOLS image
     *   sections.  The image file named out_name
     *   will receive the sum of the image file
     *   named in1_name and the image file
     *   named in2_name.
     *
     *******************************************/


add_image_array(in1_name, in2_name, out_name, 
                the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];

{
   int    i, j, length, max, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_header(in1_name, &image_header);

   max = 255;
   if(image_header.bits_per_pixel == 4)
      max = 16;

   read_tiff_image(in1_name, the_image, 
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image, 
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         out_image[i][j] = the_image[i][j] + 
                           out_image[i][j];
         if(out_image[i][j] > max)
            out_image[i][j] = max;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

}  /* ends add_image_array */





     /*******************************************
     *
     *   subtract_image_array(...
     *
     *   This function subtracts two ROWSxCOLS image
     *   sections.  The image file named out_name
     *   will receive the difference of the image file
     *   named in1_name and the image file
     *   named in2_name.
     *
     *   out_name = in1_name - in2_name
     *
     *******************************************/


subtract_image_array(in1_name, in2_name, out_name, 
                     the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];

{
   int    i, j, length, width;
   struct tiff_header_struct image_header;


   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_header(in1_name, &image_header);

   read_tiff_image(in1_name, the_image, 
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image, 
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         out_image[i][j] = the_image[i][j] - 
                           out_image[i][j];
         if(out_image[i][j] < 0)
            out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

}  /* ends subtract_image_array */
