

    /***********************************************
    *
    *    file d:\cips\edge3.c
    *
    *    Functions: This file contains
    *       gaussian_edge
    *       enhance_edges
    *
    *    Purpose:
    *       These functions implement several
    *       types of advanced edge detection.
    *
    *    External Calls:
    *       wtiff.c - round_off_image_size
    *                 create_file_if_needed
    *                 write_array_into_tiff_image
    *                 round_off_image_size
    *       tiff.c - read_tiff_header
    *       rtiff.c - read_tiff_image
    *       numcvrt.c - get_integer
    *       edge.c - fix_edges
    *
    *    Modifications:
    *       26 March 1991 - created
    *
    ***********************************************/






#include "cips.h"


short enhance_mask[3][3] =  {
       {-1,  0, -1},
       { 0,  4,  0},
       {-1,  0, -1} };



short g7[7][7] = {
     {  0,  0, -1, -1, -1,  0,  0},
     {  0, -2, -3, -3, -3, -2,  0},
     { -1, -3,  5,  5,  5, -3, -1},
     { -1, -3,  5, 16,  5, -3, -1},
     { -1, -3,  5,  5,  5, -3, -1},
     {  0, -2, -3, -3, -3, -2,  0},
     {  0,  0, -1, -1, -1,  0,  0}};

short g9[9][9] = {
   {  0,  0,  0,  -1, -1, -1,  0,  0,  0},
   {  0, -2, -3,  -3, -3, -3, -3, -2,  0},
   {  0, -3, -2,  -1, -1, -1, -2, -3,  0},
   { -1, -3, -1,   9,  9,  9, -1, -3, -1},
   { -1, -3, -1,   9, 19,  9, -1, -3, -1},
   { -1, -3, -1,   9,  9,  9, -1, -3, -1},
   {  0, -3, -2,  -1, -1, -1, -2, -3,  0},
   {  0, -2, -3,  -3, -3, -3, -3, -2,  0},
   {  0,  0,  0,  -1, -1, -1,  0,  0,  0}};



   /************************************************
   *
   *   gaussian_edge(...
   *
   *
   *************************************************/

gaussian_edge(in_name, out_name, the_image, out_image,
              il, ie, ll, le, size, threshold, high)
   char   in_name[], out_name[];
   int    high, il, ie, ll, le, size, threshold;
   short  the_image[ROWS][COLS], out_image[ROWS][COLS];
{
   char response[80];
   long sum;
   int  a, b, absdiff, absmax, diff, i, j,
        length, lower, max, new_hi, new_low,
        scale, start, stop, upper, width;

   struct tiff_header_struct image_header;


   create_file_if_needed(in_name, out_name, out_image);

   read_tiff_header(in_name, &image_header);

   new_hi  = 250;
   new_low = 16;
   if(image_header.bits_per_pixel == 4){
       new_hi  = 10;
       new_low = 3;
   }

   max = 255;
   if(image_header.bits_per_pixel == 4)
      max = 16;


   if(size == 7){
      lower = -3;
      upper =  4;
      start =  3;
      stop  =  ROWS-3;
      scale =  2;
   }

   if(size == 9){
      lower = -4;
      upper =  5;
      start =  4;
      stop  =  ROWS-4;
      scale =  2;
   }


   read_tiff_image(in_name, the_image, il, ie, ll, le);

   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         out_image[i][j] = 0;


   for(i=start; i<stop; i++){
      if ( (i%10) == 0) printf(" i=%d", i);
      for(j=start; j<stop; j++){

      sum = 0;

      for(a=lower; a<upper; a++){
         for(b=lower; b<upper; b++){
            if(size == 7)
               sum = sum + the_image[i+a][j+b] *
                     g7[a+3][b+3];
            if(size == 9)
               sum = sum + the_image[i+a][j+b] *
                     g9[a+4][b+4];
         } /* ends loop over a */
      }  /* ends loop over b */

      if(sum < 0) sum = 0;
      if(sum > max) sum = max;
      out_image[i][j] = sum;


      }  /* ends loop over j */
   }  /* ends loop over i */

     /* if desired, threshold the output image */
   if(threshold == 1){
       for(i=0; i<ROWS; i++){
          for(j=0; j<COLS; j++){
             if(out_image[i][j] > high){
                  out_image[i][j] = new_hi;
             }
             else{
                  out_image[i][j] = new_low;
             }
          }
       }
   }  /* ends if threshold == 1 */


   fix_edges(out_image, size/2);

   write_array_into_tiff_image(out_name, out_image,
                               il, ie, ll, le);

} /* ends gaussian_edge */






     /*******************************************
     *
     * enhance_edges(...
     *
     * This function enhances the edges in an
     * input image and writes the enhanced
     * result to an output image.  It operates
     * much the same way as detect_edges
     * except it uses only one type of mask.
     *
     * The threshold and high parameters perform
     * a different role in this function.  The
     * threshold parameter does not exist.  The
     * high parameter determines if the edge is
     * strong enough to enhance or change the
     * input image.
     *
     *******************************************/


enhance_edges(in_name, out_name, the_image, out_image,
             il, ie, ll, le, high)
   char   in_name[], out_name[];
   int    high, il, ie, ll, le;
   short  the_image[ROWS][COLS], out_image[ROWS][COLS];

{
   int    a, b, i, j, k,
          length, max, new_hi,
          new_lo, sum, width;
   struct tiff_header_struct image_header;


   create_file_if_needed(in_name, out_name, out_image);

   read_tiff_header(in_name, &image_header);

   max = 255;
   if(image_header.bits_per_pixel == 4)
      max = 16;


   read_tiff_image(in_name, the_image, il, ie, ll, le);

         /* Do convolution over image array */
   for(i=1; i<ROWS-1; i++){
      if( (i%10) == 0) printf("%d ", i);
      for(j=1; j<COLS-1; j++){
         sum = 0;
         for(a=-1; a<2; a++){
            for(b=-1; b<2; b++){
               sum = sum +
                     the_image[i+a][j+b] *
                     enhance_mask[a+1][b+1];
            }
         }
         if(sum < 0)   sum = 0;
         if(sum > max) sum = max;
         if(sum > high)
            out_image[i][j] = max;
         else
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   fix_edges(out_image, 1);


   write_array_into_tiff_image(out_name, out_image,
                               il, ie, ll, le);
}  /* ends enhance_edges */
