
       /*********************************************
       *
       *   file d:\cips\mainover.c
       *
       *   Functions: This file contains
       *      main
       *
       *   Purpose:
       *      This file contains the main calling
       *      routine that calls the overlay functions.
       *
       *   External Calls:
       *      gin.c - get_image_name
       *      numcvrt.c - get_integer
       *                  int_convert
       *      tiff.c - read_tiff_header
       *      overlay.c - non_zero_overlay
       *                  zero_overlay
       *                  greater_overlay
       *                  less_overlay
       *                  average_overlay
       *
       *   Modifications:
       *      6 March 1993 - created
       *
       ***********************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char     name[80], name2[80], name3[80], type[80];
   int      count, i, j,
            il1, ie1, ll1, le1,
            il2, ie2, ll2, le2,
            il3, ie3, ll3, le3,
            length, lw,
            value, width;
   struct   tiff_header_struct image_header;

   my_clear_text_screen();

       /*********************************************
       *
       *   Interpret the command line parameters.
       *
       **********************************************/

   if(argc < 5){
    printf(
    "\n\nNot enough parameters:"
     "\n"
     "\n usage: mainover in-file1 in-file2 out-file "
     "type [il ie]"
     "\n"
     "\n recall type: nonzero zero greater less"
     " average"
     "\n"
     "\n If in-file1 is only one ROWSxCOLS in size,"
     "\n then specify il ie for in-file2"
     "\n");
    exit(0);
   }

   strcpy(name,  argv[1]);
   strcpy(name2, argv[2]);
   strcpy(name3, argv[3]);
   strcpy(type,  argv[4]);

   il1 = 1;
   ie1 = 1;
   ll1 = ROWS+1;
   le1 = COLS+1;

   il2 = 1;
   ie2 = 1;
   ll2 = ROWS+1;
   le2 = COLS+1;

   il3 = 1;
   ie3 = 1;
   ll3 = ROWS+1;
   le3 = COLS+1;

       /*********************************************
       *
       *   Read the input image header and setup
       *   the looping counters.
       *
       **********************************************/

   read_tiff_header(name, &image_header);

   length = (ROWS-10 + image_header.image_length)/ROWS;
   width  = (COLS-10 + image_header.image_width)/COLS;
   count  = 1;
   lw     = length*width;
   printf("\nlength=%d  width=%d", length, width);

   if(length == 1   &&   width == 1){
      il2 = atoi(argv[5]);
      ie2 = atoi(argv[6]);
      il3 = il2;
      ie3 = ie2;
      ll2 = il2+ROWS;
      le2 = ie2+COLS;
      ll3 = il3+ROWS;
      le3 = ie3+COLS;
   }  /* ends if length == width == 1 */

       /*********************************************
       *
       *   Loop over the input images and
       *   apply the desired overlay function.
       *
       **********************************************/

   for(i=0; i<length; i++){
      for(j=0; j<width; j++){
         printf("\nrunning %d of %d", count, lw);
         count++;

            /* non-zero */
         if(strncmp("non", type, 3) == 0){
            non_zero_overlay(name, name2, name3,
                              the_image, out_image,
                              il1+i*ROWS, ie1+j*COLS,
                              ll1+i*ROWS, le1+j*COLS,
                              il2+i*ROWS, ie2+j*COLS,
                              ll2+i*ROWS, le2+j*COLS,
                              il3+i*ROWS, ie3+j*COLS,
                              ll3+i*ROWS, le3+j*COLS);
         }  /* ends non_zero operation */

            /* zero */
         if(strcmp("zero", type) == 0){
            zero_overlay(name, name2, name3,
                         the_image, out_image,
                         il1+i*ROWS, ie1+j*COLS,
                         ll1+i*ROWS, le1+j*COLS,
                         il2+i*ROWS, ie2+j*COLS,
                         ll2+i*ROWS, le2+j*COLS,
                         il3+i*ROWS, ie3+j*COLS,
                         ll3+i*ROWS, le3+j*COLS);
         }  /* ends zero operation */

            /* greater */
         if(strncmp("gre", type, 3) == 0){
            greater_overlay(name, name2, name3,
                             the_image, out_image,
                             il1+i*ROWS, ie1+j*COLS,
                             ll1+i*ROWS, le1+j*COLS,
                             il2+i*ROWS, ie2+j*COLS,
                             ll2+i*ROWS, le2+j*COLS,
                             il3+i*ROWS, ie3+j*COLS,
                             ll3+i*ROWS, le3+j*COLS);
         }  /* ends greater operation */

            /* less */
         if(strncmp("les", type, 3) == 0){
            less_overlay(name, name2, name3,
                          the_image, out_image,
                          il1+i*ROWS, ie1+j*COLS,
                          ll1+i*ROWS, le1+j*COLS,
                          il2+i*ROWS, ie2+j*COLS,
                          ll2+i*ROWS, le2+j*COLS,
                          il3+i*ROWS, ie3+j*COLS,
                          ll3+i*ROWS, le3+j*COLS);
         }  /* ends less operation */

            /* average */
         if(strncmp("ave", type, 3) == 0){
            average_overlay(name, name2, name3,
                             the_image, out_image,
                              il1+i*ROWS, ie1+j*COLS,
                              ll1+i*ROWS, le1+j*COLS,
                              il2+i*ROWS, ie2+j*COLS,
                              ll2+i*ROWS, le2+j*COLS,
                              il3+i*ROWS, ie3+j*COLS,
                              ll3+i*ROWS, le3+j*COLS);
         }  /* ends average operation */


      }  /* ends loop over j */
   }  /* ends loop over i */
}  /* ends main  */
