
    /***********************************************
    *
    *    file d:\cips\pattern.c
    *
    *    Functions: This file contains
    *       main
    *
    *    Purpose:
    *       I use this program to create simple
    *       patterns in images for illustrations.
    *
    *    External Calls:
    *       gpcips.c - my_clear_text_screen
    *       wtiff.c - create_allocate_tiff_file
    *                 write_array_into_tiff_image
    *
    *    Modifications:
    *       31 March 1991 - created
    *       17 May 1993 - made this a command
    *           line driven program.
    *
    ***********************************************/

#include "cips.h"
#undef STUFF


short p1[10][10] = 
   {{11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11}};

short p2[10][10] = 
   {{11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
    {11, 11, 11, 11, 11, 11, 11, 11, 11, 11}};




short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{
   int      count, i, ie, ii, il, j, jj, le, l, ll,
            new_ie, new_il, set_i, set_j, square_size, w;
   struct   tiff_header_struct image_header;


   my_clear_text_screen();

   if(argc < 4 ){
      printf("\n usage: pattern file-name "
             "length width\n"
             "\n the program will multiply length "
             "and width"
             "\n by %d and %d", ROWS, COLS);
      exit(-1);
   }

   l = atoi(argv[2]);
   w = atoi(argv[3]);

   image_header.lsb            = 1;
   image_header.bits_per_pixel = 8;
   image_header.image_length   = l*ROWS;
   image_header.image_width    = w*COLS;;
   image_header.strip_offset   = 1000;

   create_allocate_tiff_file(argv[1], &image_header, 
                             out_image);

   new_ie = 1;
   new_il = 1;
   il     = 1;
   ie     = 1;
   ll     = ROWS+1;
   le     = COLS+1;

   /********************************************/


      /* make a blank image that is not zero */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
		   out_image[i][j] = 150;
	   }
   }

   /********************************************/

   count = 1;
   for(i=0; i<l; i++){
      for(j=0; j<w; j++){
         printf("\nRunning %d of %d", count, l*w);
         count++;
         write_array_into_tiff_image(argv[1], out_image,
                         new_il + i*ROWS,
                         new_ie + j*COLS,
                         new_il + i*ROWS + ROWS,
                         new_ie + j*COLS + COLS);
      }
   }

}  /* ends main */






#ifdef STUFF


/*
   The following are samples patterns you can stick
   into the output image.
*/




     /* make a step pattern of gray shades */
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
        out_image[i][j] = 0;
   for(i=0; i<ROWS; i++)
      for(j=10; j<20; j++)
        out_image[i][j] = 5;
   for(i=0; i<ROWS; i++)
      for(j=20; j<30; j++)
        out_image[i][j] = 10;
   for(i=0; i<ROWS; i++)
      for(j=30; j<40; j++)
        out_image[i][j] = 20;


     /*  make a club to look at thinning and mat */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
        if( i>4 && i<11 && j>4 && j<17)
          out_image[i][j] = 200;
        else
          out_image[i][j] = 0;
    }
   }
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
        if( i>1 && i<17 && j>4 && j<11)
          out_image[i][j] = 200;
    }
   }


      /*  make a rectangle with a hole in it */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
        if( i>=5 && i<=8 && j>=5 && j<=18)
          out_image[i][j] = 200;
    }
   }
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
        if( i>=15 && i<=18 && j>=5 && j<=18)
          out_image[i][j] = 200;
    }
   }
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
        if( j>=5 && j<=8 && i>=5 && i<=18)
          out_image[i][j] = 200;
    }
   }
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
        if( j>=15 && j<=18 && i>=5 && i<=18)
          out_image[i][j] = 200;
    }
   }

     /* make the entire area white with a black hole
     in it good for interior outline */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         if( i>=10 && i<=15 && j>=10 && j<=18)
            out_image[i][j] = 0;
         else
            out_image[i][j] = 200;
      }
   }


      /* make a square  */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         if( i>=8 && i<=18 && j>=8 && j<=18)
            out_image[i][j] = 200;
         else
            out_image[i][j] = 0;
      }
   }

      /* make a square  with a hole in
        it for closing practice */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         if( i>=8 && i<=13 && j>=8 && j<=13)
            out_image[i][j] = 200;
         else
            out_image[i][j] = 0;
      }
   }
   out_image[10][10] = 0;
   out_image[11][10] = 0;

      /* make 2 small squares
        illustrate closing and special closing */
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         out_image[i][j] = 0;
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         if( i>=8 && i<=13 && j>=8 && j<=9)
            out_image[i][j] = 200;
         if( i>=8 && i<=13 && j>=11 && j<=13)
            out_image[i][j] = 200;
      }
   }

      /* make a rectangle  */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         if( i>=8 && i<=18 && j>=4 && j<=18)
            out_image[i][j] = 200;
         else
            out_image[i][j] = 0;
      }
   }

      /* make a block letter A */
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         out_image[i][j] = 0;
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         if(i>=10 && i<=20 && j>=10 && j<=50)
          out_image[i][j] = 200;
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         if(i>=40 && i<=50 && j>=10 && j<=50)
          out_image[i][j] = 200;
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         if(i>=10 && i<=90 && j>=10 && j<=20)
          out_image[i][j] = 200;
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         if(i>=10 && i<=90 && j>=40 && j<=50)
          out_image[i][j] = 200;

      /* make a broken line */
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         out_image[i][j] = 0;
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         if(i>=10 && i<=11 && j>=5 && j<=18)
          out_image[i][j] = 200;
   out_image[10][11] = 0;
   out_image[11][11] = 0;


      /* make two squares joined together */
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         out_image[i][j] = 0;
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
         if( i>=5 && i<=15 && j>=5 && j<=9)
            out_image[i][j] = 200;
         if( i>=5 && i<=15 && j>=12 && j<=17)
            out_image[i][j] = 200;
      }
   }
   out_image[10][10] = 200;
   out_image[10][11] = 200;




   /* make a texture, checkerboard of 100-200
      with each square the size given by the 
      variable square_size 
      I'll do this a little different and let
      the user specify the square size as the
      last parameter on the line. */

   sqaure_size = atoi(argv[4]);
   ii=0; 
   jj=0; 
   set_i=0; 
   set_j=0;
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){

            /* odd rows */
         if( (set_i%2) == 0){
            if( (set_j%2) == 0)
               out_image[i][j] = 100;
            else
               out_image[i][j] = 200;
         }
            /* even rows */
         else{
            if( (set_j%2) == 0)
               out_image[i][j] = 200;
            else
               out_image[i][j] = 100;
         }

         jj++;
         if(jj > square_size){
            jj = 0;
            set_j++;
         }
      }  /* ends loop over j */

      jj=0; 
      set_j=0;
      ii++;
      if(ii > square_size){
         ii = 0;
         set_i++;
      }
   }  /* ends loop over i */


      /* create a random image 0-255 */
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
        out_image[i][j] = (rand() % 255);


      /* create a random image 100-150  */
   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
        out_image[i][j] = 100 + (rand() %  50);


      /* make vertical stripes */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
		   if( (j > 10  &&  j < 30)    ||
		       (j > 50  &&  j < 70)    ||
		       (j > 90  &&  j < 99) )
			   out_image[i][j] = 200;
			else
			   out_image[i][j] = 50;
	   }
   }


      /* make a blank image that is not zero */
   for(i=0; i<ROWS; i++){
      for(j=0; j<COLS; j++){
		   out_image[i][j] = 150;
	   }
   }


#endif
