/* Listing 5		Iterative, Fixed Point Line Routine */

/*
	This function relies on the Borland graphics library
*/


#include <graphics.h>


#define FixedPointShiftAmount 8

#define FPToInteger( FP )  ( FP >> FixedPointShiftAmount )
#define IntegerToFP( Integer )  ( Integer << FixedPointShiftAmount )


typedef long FixedPnt;


void IterativeLine( short x1, short y1, short x2, short y2 )
{
	/* This dt gives 128 steps */
	FixedPnt t, dt = 1 << ( FixedPointShiftAmount - 6 );
	FixedPnt x, y, dx, dy;

	/* Compute FixedPnt deltas */
	dx = ( x2 - x1 ) * dt;
	dy = ( y2 - y1 ) * dt;

	/* Initial values */
	x = IntegerToFP( (long) x1 );
	y = IntegerToFP( (long) y1 );

	putpixel( x1, y1, 15 );

	for( t = 0; t < IntegerToFP( 1 ); t += dt )
	{
		x += dx;
		y += dy;
		
		putpixel( FPToInteger( x ), FPToInteger( y ), 14 );
	}
}

