/*############################  Listing 1:  ############################*/

/* fmutl.h - flash memory utility module header */


#ifndef FMUTL_H_
#define	FMUTL_H_



	/* macro returning number of elements in an array: */
#define	ARRAY_LEN(a)	(sizeof(a) / sizeof((a)[0]))


/*****************************************************************************
The fm_status() routine can return the following information about flash
memory devices.  NOTE:  fields ending with '_' are intended for internal
use by fmutl.c only:
*****************************************************************************/

typedef struct	{	/** Flash Memory information structure: **/
		/* private: */
	unsigned short MfrID_;		/* (manufacturer ID code) */
	unsigned short DevID_;		/* (device ID code) */
	short MaxErase_;		/* (max erase time in seconds) */
	short MaxWrite_;		/* (max byte-write time in ms) */
	int NumSect_;			/* (number of sectors per chip) */
		/* public: */
	size_t SectorSize;		/* bytes per sector (both chips) */
	size_t TotalSize;		/* total number of bytes (both chips) */
	int NumProt;			/* >= 0: # of protected sectors;
					  -1: prot. sectors are non-contiguous
					  -2: prot. mismatched b/w devices */
	int FirstProt;			/* first protected sector, ordinal 0 */
	char *pDevName;			/* ptr to manufacturer & device name */
} FMINFO;


/*****************************************************************************
If the return value of a routine in fmutl.c indicates failure, the fm_err
global structure will contain the following additional information about
the error.
*****************************************************************************/

typedef	struct	{	/** Flash routine error information structure: **/
	unsigned short *addr;	/* flash memory address of problem */
	unsigned short exp;	/* value expected */
	unsigned short act;	/* actual value read */
	unsigned char code;	/* error code byte (see fmutl.c) */
	char *pMsg;		/* ptr to error message string */
} FMERR;

extern	FMERR	fm_err;		/* defined in fmutl.c */


/*****************************************************************************
Prototypes for the global routines in fmutl.c:
*****************************************************************************/

#ifdef __STDC__

extern fm_status(unsigned short *pBase, FMINFO *pFMInfo);

extern fm_write(unsigned short *pBase, unsigned short *pDst,
		unsigned short *pSrc, size_t length, unsigned short *pScrBuf);

extern void fm_error(unsigned short *addr, unsigned short exp,
		     unsigned short act, int errcode);

#endif

#endif  /* FMUTL_H_ */

