LISTING 1 - Converts a hex-string to a number in ASCII environments

#include <ctype.h>
#include <assert.h>

long atox(char *s)
{
     long sum;

     assert(s);

     /* Skip whitespace */
     while (isspace(*s))
          ++s;

     /* Do the conversion */
     for (sum = 0L; isxdigit(*s); ++s)
     {
          int digit;

          if (isdigit(*s))
               digit = *s - '0';
          else
               digit = toupper(*s) - 'A' + 10;
          sum = sum*16L + digit;
     }

     return sum;
}

