LISTING 5 - A Function that copies a file via block I/O

/* copy2.c */
#include <stdio.h>

int copy(FILE *dest, FILE *source)
{
    size_t count;
    static char buf[BUFSIZ];

    while (!feof(source))
    {
        count = fread(buf,1,BUFSIZ,source);
        if (ferror(source))
            return EOF;
        if (fwrite(buf,1,count,dest) != count)
            return EOF;
    }
    return 0;
}

