LISTING 12 - Uses strstr to find substrings

/* find.c:    Extract lines from a file */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

main(int argc, char *argv[])
{
    char line[BUFSIZ];
    char *search_str;
    int lineno = 0;

    if (argc == 1)
        return EXIT_FAILURE;   /* Search string required */
    else
        search_str = argv[1];

    while (gets(line))
    {
        ++lineno;
        if (strstr(line,search_str))
            printf("%d:  %s\n",lineno,line);
    }

    return EXIT_SUCCESS;
}

/* Results from the command "find str <find.c": */
5:  #include <string.h>
12:      char *search_str;
16:          return EXIT_FAILURE;
18:          search_str = argv[1];
23:          if (strstr(line,search_str))

