LISTING 13 - Illustrates selected string search functions

#include <stdio.h>
#include <string.h>

void display_span(char *, int);

main()
{
    char *s = "Eeek! A mouse device!";
    char *vowels = "AEIOUaeiou";
    char *punct = "`~!@#$%^&*()-_=+\\|[{]};:'\",<.>/?";
    char *ptr;

    display_span(s,strspn(s,vowels));
    display_span(s,strspn(s,punct));
    display_span(s,strcspn(s,vowels));
    display_span(s,strcspn(s,punct));

    ptr = strpbrk(s,vowels);
    puts(ptr);

    ptr = strpbrk(s,punct);
    puts(ptr);

    return 0;
}

void display_span(char *s, size_t index)
{
    printf("%d characters spanned: %.*s\n",
            index,index,s);
}

/* Output: */
3 characters spanned: Eee
0 characters spanned: 
0 characters spanned: 
4 characters spanned: Eeek
Eeek! A mouse device!
! A mouse device!

