/* ------------ */
/* defcodes.h	*/
/* ------------ */
# ifndef  __DEFCODES
#	define	__DEFCODES

# ifdef	UNIX
#	define	NO_EXT_KEYS
# endif

#include <ctype.h>
#undef	tolower
#undef	toupper

#include <stdlib.h>
#include <limits.h>
# if _MSDOS
#	include <malloc.h>
# endif
#include <stdio.h>
#include <io.h>
#include <string.h>

# if _MSC_VER >= 700
#	pragma	warning(disable:4131)
# endif

#define	EOS	'\0'	/* End of string */
#define	ERROR	 -1
#define	EXISTS	  0	/* for call to _access() */
#define	FALSE	  0
#define	NO	  0
#define	NOTFOUND -1
#define	OK	  0

# ifndef TRUE
#    define	TRUE	 1
# endif

#define	YES	 1

/* ------------------------------------------------ */
/* NUM_ITEMS(A) - Yields number of items in array A */
/* ------------------------------------------------ */
#define	NUM_ITEMS(A)	(sizeof(A)/sizeof(*(A)))

# ifndef DEBUG
#	define	P( F )
#	define	hello(a)
#	define	D(f)
#	define	D1(f,p)
#	define	D2(f,p1,p2)
#	define	D3(f,p1,p2,p3)
#	define	D4(f,p1,p2,p3,p4)
#	define	D5(f,p1,p2,p3,p4,p5)
#	define	D6(f,p1,p2,p3,p4,p5,p6)
#	define	PRIVATE		static
# else
#	define	P( F )			F
#	define	hello(a)		E1("%s\n",a)
#	define	D(f)			E(f)
#	define	D1(f,p) 		E1(f,p)
#	define	D2(f,p1,p2)		E2(f,p1,p2)
#	define	D3(f,p1,p2,p3) 		E3(f,p1,p2,p3)
#	define	D4(f,p1,p2,p3,p4)	E4(f,p1,p2,p3,p4)
#	define	D5(f,p1,p2,p3,p4,p5)	E5(f,p1,p2,p3,p4,p5)
#	define	D6(f,p1,p2,p3,p4,p5,p6)	E6(f,p1,p2,p3,p4,p5,p6)
#	define	PRIVATE
# endif

#define	E(f)			fprintf(stderr,f)
#define	E1(f,p)			fprintf(stderr,f,p)
#define	E2(f,p1,p2)		fprintf(stderr,f,p1,p2)
#define	E3(f,p1,p2,p3)		fprintf(stderr,f,p1,p2,p3)
#define	E4(f,p1,p2,p3,p4)	fprintf(stderr,f,p1,p2,p3,p4)
#define	E5(f,p1,p2,p3,p4,p5)	fprintf(stderr,f,p1,p2,p3,p4,p5)
#define	E6(f,p1,p2,p3,p4,p5,p6)	fprintf(stderr,f,p1,p2,p3,p4,p5,p6)

# if defined(DEBUG)
#	define	PX(a)	AX(a)
# else
#	define	PX(a)
# endif

#define	AX(a)	printf a		/* Always print */
#define	EX(a)	fprintf(stderr, a)
#define	NX(a)				/* NULL function */

#define	SQR(a)		((a)*(a))

# ifdef	abs
#    undef	abs
# endif

typedef	long     double		LDBL;
typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;
typedef unsigned long		ULONG;
typedef	unsigned short		USHORT;

# endif /* <<< __DEFCODES >>> */
