// DIB_DOS.H - MS-Windows DIB Data Structures for MS-DOS

#ifndef _DIB_DOS_H
#define _DIB_DOS_H

#include "general.h"

// The following are MS-DOS equivalents of the BM and RGB
// definitions and data structures defined in <windows.h>
// for MS-Windows device-independent bitmaps (DIBs).

static const DWORD DIB_BI_RGB = 0L;    // No compression

struct DIB_FileHeader   // DIB file header
{
  UINT bfType;          // File type - must be 'BM'
  DWORD bfSize;         // File size (in bytes)
  UINT bfReserved1;     // Reserved (must be zero)
  UINT bfReserved2;     // Reserved (must be zero)
  DWORD bfOffBits;      // Bitmap data offset (in bytes)
};

struct DIB_InfoHeader   // DIB information header
{
  DWORD biSize;         // Structure size (in bytes)
  LONG biWidth;         // Bitmap width (in pixels)
  LONG biHeight;        // Bitmap height (in pixels)
  WORD biPlanes;        // Number of planes (always 1)
  WORD biBitCount;      // Bits per pixel
  DWORD biCompression;  // Compression type
  DWORD biSizeImage;    // Image size (in bytes)
  LONG biXPelsPerMeter; // Horizontal resolution
  LONG biYPelsPerMeter; // Vertical resolution
  DWORD biClrUsed;      // Number of color indices used
  DWORD biClrImportant; // Number of important color indices
};

struct DIB_Palette      // RGB color (RGBQUAD)
{
  BYTE rgbBlue;
  BYTE rgbGreen;
  BYTE rgbRed;
  BYTE rgbReserved;     // Reserved (must be zero)
};

#endif

