const unsigned BLOCKSIZE = 60*1024;
const int MAXBLOCK = 64;

class Heap{
  void far* block[MAXBLOCK] // Array of far
                            // pointers to 
                            // memory blocks
  int n;                    // No. of blocks 
                            // in use
  unsigned pos;             // Next vacant
                            // position within
                            // current block

  public:
  Heap()
    { n = 0;
    }
  ~Heap()
    { for (int i = 0; i<n; i++)
        GlobalFreePtr(block[i]);
    }
  void far* New(unsigned nBytes)
    {
      // Allocate another block if necessary
      if (n == 0 || nBytes > BLOCKSIZE - pos){
        assert(n < MAXBLOCK && nBytes <= BLOCKSIZE);
        block[n++] = GlobalAllocPtr(GHND, BLOCKSIZE);
        assert(block[n-1] != 0);
        pos = 0;
      }
      // Get a pointer from within the current<%0> block
      void far* p =
          ((char far*) block[n-1]) + pos;
      pos += nBytes;
      return p;
    }
};

