LISTING 24 - SetOfInt implementation
// set.cpp
#include <iostream.h>
#include <algo.h>
#include "set.h"

SetOfInt::SetOfInt()
{
    nelems = 0;
}

bool SetOfInt::contains(int x) const
{
    const int *begin = elems;
    const int *end = elems + nelems;
    return find(begin,end,x) != end;
}

void SetOfInt::insert(int x)
{
    if (nelems < LIMIT && !contains(x))
        elems[nelems++] = x;
}

void SetOfInt::remove(int x)
{
    const int *begin = elems;
    const int *end = begin + nelems;
    const int *p = find(begin,end,x);

    if (p != end)
    {
        // Shuffle elements up to cover x
        for (int *q = (int *)p; q < end-1; ++q)
            *q = *(q+1);
        --nelems;
    }
}

void SetOfInt::print(ostream & os) const
{
    os << '{';
    for (int i = 0; i < nelems; ++i)
    {
        if (i > 0)
            os << ',';
        os << elems[i];
    }
    os << '}';
}

