// CTLCHECK implementation
//////////////////////////////////////////////////////
#include "CONTROLS.HPP"
#include "KW.HPP"
CTLCHECK::CTLCHECK(const DESCRIPT& Desc,
			SHOWDATA* Guru,
			const CTLMAPPER* Map)
	: CTL(Desc, Guru), _map(Map)
{
STR Label;
_desc.value(KW::LABEL, Label);
_duh = _map->duSquareBox();
_duw = _duh + _map->duwText(Label);
}

CTLCHECK::~CTLCHECK()
{
}

int CTLCHECK::addToDlg(int nFirstFreeId,
						MEMBLOCK *pTemplate,
						int duX, int duY)
{
CTL::DLGITEM check(CTL::_Check);
check.dtilX = duX;
check.dtilY = duY;
check.dtilCX = _duw;
check.dtilCY = _duh;
_idC = nFirstFreeId;
check.dtilID = _idC;
pTemplate->add((unsigned char*)&check, sizeof(check));
return 1;
}

void CTLCHECK::dataToScreen()
{
STR Label;
_desc.value(KW::LABEL, Label);
SetDlgItemText(_hDlg, _idC, Label);

STR Var;
_desc.value(KW::VAR, Var);
int val = _guru->get(Var) ? 1 : 0;
SendDlgItemMessage(_hDlg, _idC, BM_SETCHECK, val, 0);
}

void CTLCHECK::saveData()
{
int val = SendDlgItemMessage(_hDlg, _idC,
				BM_GETCHECK, 0, 0);
STR Var;
_desc.value(KW::VAR, Var);
_guru->set(Var, val);
}

