/*
echoto.c
cc echoto.c -o echoto

    FLenk 5/14/92
    Program for restricted shell users to perform a function similar
    to the Bourne shell's:  echo "this is a test" >> filename
    The restricted shell does not permit redirection, so we  cheat
    a bit with this program.  echoto will gather all the command line
    parameters and send them as a single string to the filename.
    Syntax:  echoto filename "strings including $VARS and `cmds`"
    Examples:

    The following produce the same results:
        echoto junk "this is a test"
        echoto junk this is a test
    But these produce different results
        echoto junk "tab        tab"        (saves "tab        tab")
        echoto junk tab        tab         (saves "tab tab")
        (where the space between the word tab is an actual tab)
    The following produces 2 separate output lines:
        echoto junk "first line
        second line"
    The following:
        echoto junk "LOGIN $LOGNAME `date`"
    adds to the filename junk:
        LOGIN fred Thu May 14 12:23:00 PDT 1992

    By adding "chmod 755 junk" to this utility, the target file becomes
    an executable.  One can build shell scripts on the fly.

    Experiment in a safe directory with different variations of echoto
    before incorporating echoto in a program used in the rsh.

*/


#ident "@(#) echoto  Append lines to a file in rsh. Fred Lenk 5/14/92"
#include <stdio.h>
#include <string.h>


main(argc,argv)
int argc;
char **argv;
{
    int i;
    char cmdline[80];
    FILE *fd;

    if(argc < 3) {
        fprintf(stderr,"%s is used in the restricted shell to add lines to the end of a file\n",argv[0]);
        fprintf(stderr,"    in a similar fashion as redirection in the Bourne Shell.  Redirection\n");
        fprintf(stderr,"    in the restricted shell is illegal, thus we need to use %s.\n",argv[0]);
        fprintf(stderr,"Usage: %s filename \"strings including $VARS and \`cmds\`\"\n",argv[0]);
        exit(1);
    }

    fd=fopen(argv[1],"a"); /* open for append, or create if not exist */
    if(fd==NULL) {
        fprintf(stderr,"Error opening file for append/create: %s\n",argv[1]);
        sleep(2);
    }

    for(i=2;i<argc;i++) {  /*starting with 3rd parameter, */
        fputs(argv[i],fd); /*add command line params to file*/
        fputs(" ",fd);     /*separated by spaces.*/
    }
    fputs("\n",fd);

    return;
}/*end main*/
/*end echoto.c*/
