/*
fcvtim.c
cc fcvtim.c -o fcvtim

          Convert Julian seconds since 1/1/70 00:00:00 GMT to date time
          format of mm/dd/yy hh:mm:ss.  That is, fcvtim receives a long
          value and does the conversion.  eg:  fcvtim 707765596 produces
          06/05/92 10:33:16.

          ftim utility can be used to create the long seconds value.
          Test using following command:  fcvtim `ftim`


Fred Lenk  11/5/93

*/


#ident "@(#) fcvtim  Convert time_t value to date & time. Fred Lenk 11/5/93."

#include <time.h>
#include <stdio.h>

main(argc,argv)
int argc;
char **argv;
{

    struct tm when;
    time_t then; /*really, this is a long*/

    /*do some prelim checks and bail if necessary */
    if(argc!=2) {
        printf("Syntax: %s time_in_seconds (type time_t, see time.h)\n",argv[0]);
        exit(1);
    }

    then=atol(argv[1]);
    /*init our time logic*/
    when = *localtime(&then);
    /*print date & time*/
    printf("%02d/%02d/%02d %02d:%02d:%02d\n",when.tm_mon + 1,when.tm_mday, \
        when.tm_year,when.tm_hour,when.tm_min,when.tm_sec);
    return;
}  /*end of main*/
/*end fcvtim.c*/
