CLISP(1)                 USER COMMANDS                   CLISP(1)

NAME
     clisp - Common Lisp language interpreter and compiler

SYNOPSIS
     clisp [ -h ] [ -m memsize ] [ -s stacksize ] [ -M memfile  ]
     [ -L language ] [ -q ] [ -I ] [ -i initfile ...  ] [ -c [ -l
     ] lispfile [ -o outputfile ] ...  ] [ -p packagename ] [  -x
     expression ]

DESCRIPTION
     Invokes the common lisp interpreter and  compiler.   Invoked
     without arguments, executes a read-eval-print loop, in which
     expressions are in turn read from standard input,  evaluated
     by  the  lisp interpreter, and their results output to stan-
     dard output.  Invoked with -c, the specified lisp files  are
     compiled  to  a  bytecode  that  can  be executed more effi-
     ciently.

OPTIONS
     -h   Displays a help message on how to use clisp.

     -m memsize
          Sets the amount  of  memory  clisp  tries  to  grab  on
          startup.   The amount may be given as nnnnnnn (measured
          in bytes), nnnnK or nnnnKB (measured in  kilobytes)  or
          nM  or nMB (measured in megabytes).  Default is 2 mega-
          bytes.  The argument is constrained between 100 KB  and
          16  MB.   --  This  version  of  clisp allocates memory
          dynamically.  memsize is essentially ignored.

     -s stacksize
          Sets the size of the stack clisp allocates for  itself.
          The  syntax is the same as for memsize.  Default is one
          eighth of memsize.  The argument is constrained between
          40 KB and 8 MB.

     -M memfile
          Specifies the initial memory image.   This  must  be  a
          memory dump produced by the saveinitmem function.

     -L language
          Specifies the language clisp uses to  communicate  with
          the user. This may be english, deutsch, francais.

     -q   Quiet: clisp displays  no  banner  at  startup  and  no
          good-bye message when quitting.

     -I   ILISP friendly: clisp interacts in a way that ILISP  (a
          popular Emacs LISP interface) can deal with.  Currently
          the only effect of this is that unnecessary prompts are
          not suppressed.

     -i initfile ...
          Specifies initialization files to be loaded at startup.
          These should be lisp files (source or compiled).

     -c lispfile ...
          Compiles the specified lispfiles to bytecode. The  com-
          piled  files  can then be loaded instead of the sources
          to gain efficiency.

     -o outputfile
          Specifies the output file or directory for the compila-
          tion of the last specified lispfile.

     -l   A bytecode listing of the files being compiled will  be
          produced.  Useful only for debugging purposes.

     -p packagename
          At startup the value of the variable *package* will  be
          set to the package named packagename.

     -x expressions
          Executes a series of arbitrary expressions instead of a
          read-eval-print  loop.   The  values of the expressions
          will be output to standard output.  Due to the argument
          processing  done  by the shell, the expressions must be
          enclosed  in  single  quotes,  and  double  quotes  and
          backslashes must be preceded by backslashes.

WORKBENCH
     Two kinds of tooltypes are supported:

     WINDOW= windowspec
          clisp will communicate with the console window or  pipe
          specified by windowspec.

     ARGS= arguments
          Specifies the command line arguments for clisp.  Within
          arguments  the  token  `*'  may  be  used to denote the
          project's filename.  arguments defaults to `-i *' which
          means that the file will be loaded (see above).

REFERENCE
     The language implemented conforms to
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 1st edition 1984, 465 pages.
            ("CLtL1" for short)
     and to the older parts of
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 2nd edition 1990, 1032 pages.
            ("CLtL2" for short)

USE
     help to get some on-line help.

     (apropos name)
          lists the symbols relating to name.

     (exit) or (quit) or (bye)
          to quit clisp.

     EOF (Ctrl-\)
          to leave the current read-eval-print loop.

FILES
     lisp.run
          main executable

     lispinit.mem
          initial memory image

     config.lsp
          site-dependent configuration

     *.lsp
          lisp source

     *.fas
          lisp code, compiled by clisp

     *.lib
          lisp source library information, generated and used  by
          the clisp compiler

ENVIRONMENT
     CLISP_LANGUAGE
          specifies the language clisp uses to  communicate  with
          the  user.  The value may be english, deutsch, francais
          and defaults to english.  The -L option can be used  to
          override this environment variable.

     Language
          specifies the language clisp uses to  communicate  with
          the  user,  unless  it is already specified through the
          environment variable CLISP_LANGUAGE or the  -L  option.
          The value may be as above.

     LANG specifies the language clisp uses to  communicate  with
          the  user,  unless  it is already specified through the
          environment variable CLISP_LANGUAGE or the  -L  option.
          The  value may begin with a two-letter ISO 639 language
          code, for example en, de, fr.

SEE ALSO
     cmulisp(1), emacs(1).

BUGS
     The function inspect is not implemented.

     Not all extensions from CLtL2 are supported.

     No on-line documentation  beyond  apropos  and  describe  is
     available.

PROJECTS
     Writing on-line documentation.

     Write inspect.

     Enhance the compiler such that it  can  inline  local  func-
     tions.

     Specify a portable set of window and graphics operations.

AUTHORS
     Bruno Haible <haible@ma2s2.mathematik.uni-karlsruhe.de>  and
     Michael Stoll.
