dnl -*- Autoconf -*-
dnl Copyright (C) 2002, 2005 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_PREREQ(2.13)

dnl Each of the macros determines a facet of the default floating-point
dnl environment.
dnl   CL_FLOAT_DIV0        CL_DOUBLE_DIV0        CL_LONGDOUBLE_DIV0
dnl   CL_FLOAT_OVERFLOW    CL_DOUBLE_OVERFLOW    CL_LONGDOUBLE_OVERFLOW
dnl   CL_FLOAT_UNDERFLOW   CL_DOUBLE_UNDERFLOW   CL_LONGDOUBLE_UNDERFLOW
dnl   CL_FLOAT_INEXACT     CL_DOUBLE_INEXACT     CL_LONGDOUBLE_INEXACT


AC_DEFUN([CL_FLOAT_DIV0],
[
  AC_MSG_CHECKING([whether single-float divbyzero raises an exception])
  AC_CACHE_VAL(cl_cv_cc_float_divbyzero, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
static void sigfpe_handler (int sig) { exit (1); }
float x = 1;
float y = 0;
float z;
float nan;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x / y; nan = y / y;
  exit (0);
}
], cl_cv_cc_float_divbyzero=no, cl_cv_cc_float_divbyzero=yes,
   cl_cv_cc_float_divbyzero="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_float_divbyzero])
  if test "$cl_cv_cc_float_divbyzero" = yes; then
    AC_DEFINE(FLOAT_DIV0_EXCEPTION,1,
      [Define to 1 if 'float' division by zero raises an exception.])
  fi
])

AC_DEFUN([CL_DOUBLE_DIV0],
[
  AC_MSG_CHECKING([whether double-float divbyzero raises an exception])
  AC_CACHE_VAL(cl_cv_cc_double_divbyzero, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
static void sigfpe_handler (int sig) { exit (1); }
double x = 1;
double y = 0;
double z;
double nan;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x / y; nan = y / y;
  exit (0);
}
], cl_cv_cc_double_divbyzero=no, cl_cv_cc_double_divbyzero=yes,
   cl_cv_cc_double_divbyzero="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_double_divbyzero])
  if test "$cl_cv_cc_double_divbyzero" = yes; then
    AC_DEFINE(DOUBLE_DIV0_EXCEPTION,1,
      [Define to 1 if 'double' division by zero raises an exception.])
  fi
])

AC_DEFUN([CL_LONGDOUBLE_DIV0],
[AC_REQUIRE([gt_TYPE_LONGDOUBLE])
if test "$gt_cv_c_long_double" = yes; then
  AC_MSG_CHECKING([whether long-float divbyzero raises an exception])
  AC_CACHE_VAL(cl_cv_cc_longdouble_divbyzero, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
static void sigfpe_handler (int sig) { exit (1); }
long double x = 1;
long double y = 0;
long double z;
long double nan;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x / y; nan = y / y;
  exit (0);
}
], cl_cv_cc_longdouble_divbyzero=no, cl_cv_cc_longdouble_divbyzero=yes,
   cl_cv_cc_longdouble_divbyzero="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_longdouble_divbyzero])
  if test "$cl_cv_cc_longdouble_divbyzero" = yes; then
    AC_DEFINE(LONGDOUBLE_DIV0_EXCEPTION,1,
      [Define to 1 if 'long double' division by zero raises an exception.])
  fi
fi
])


AC_DEFUN([CL_FLOAT_OVERFLOW],
[
  AC_MSG_CHECKING([whether single-float overflow raises an exception])
  AC_CACHE_VAL(cl_cv_cc_float_overflow, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
#include <float.h>
static void sigfpe_handler (int sig) { exit (1); }
float x = FLT_MAX;
float y = FLT_MAX;
float z;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x * y;
  exit (0);
}
], cl_cv_cc_float_overflow=no, cl_cv_cc_float_overflow=yes,
   cl_cv_cc_float_overflow="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_float_overflow])
  if test "$cl_cv_cc_float_overflow" = yes; then
    AC_DEFINE(FLOAT_OVERFLOW_EXCEPTION,1,
      [Define to 1 if 'float' overflow raises an exception.])
  fi
])

AC_DEFUN([CL_DOUBLE_OVERFLOW],
[
  AC_MSG_CHECKING([whether double-float overflow raises an exception])
  AC_CACHE_VAL(cl_cv_cc_double_overflow, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
#include <float.h>
static void sigfpe_handler (int sig) { exit (1); }
double x = DBL_MAX;
double y = DBL_MAX;
double z;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x * y;
  exit (0);
}
], cl_cv_cc_double_overflow=no, cl_cv_cc_double_overflow=yes,
   cl_cv_cc_double_overflow="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_double_overflow])
  if test "$cl_cv_cc_double_overflow" = yes; then
    AC_DEFINE(DOUBLE_OVERFLOW_EXCEPTION,1,
      [Define to 1 if 'double' overflow raises an exception.])
  fi
])

AC_DEFUN([CL_LONGDOUBLE_OVERFLOW],
[AC_REQUIRE([gt_TYPE_LONGDOUBLE])
if test "$gt_cv_c_long_double" = yes; then
  AC_MSG_CHECKING([whether long-float overflow raises an exception])
  AC_CACHE_VAL(cl_cv_cc_longdouble_overflow, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
#include <float.h>
static void sigfpe_handler (int sig) { exit (1); }
long double x;
long double y;
long double z;
int main ()
{
  x = LDBL_MAX;
  y = LDBL_MAX;
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x * y;
  exit (0);
}
], cl_cv_cc_longdouble_overflow=no, cl_cv_cc_longdouble_overflow=yes,
   cl_cv_cc_longdouble_overflow="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_longdouble_overflow])
  if test "$cl_cv_cc_longdouble_overflow" = yes; then
    AC_DEFINE(LONGDOUBLE_OVERFLOW_EXCEPTION,1,
      [Define to 1 if 'long double' overflow raises an exception.])
  fi
fi
])


AC_DEFUN([CL_FLOAT_UNDERFLOW],
[
  AC_MSG_CHECKING([whether single-float underflow raises an exception])
  AC_CACHE_VAL(cl_cv_cc_float_underflow, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
#include <float.h>
static void sigfpe_handler (int sig) { exit (1); }
float x = FLT_MIN;
float y = FLT_MIN;
float z;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x * y;
  exit (0);
}
], cl_cv_cc_float_underflow=no, cl_cv_cc_float_underflow=yes,
   cl_cv_cc_float_underflow="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_float_underflow])
  if test "$cl_cv_cc_float_underflow" = yes; then
    AC_DEFINE(FLOAT_UNDERFLOW_EXCEPTION,1,
      [Define to 1 if 'float' underflow raises an exception.])
  fi
])

AC_DEFUN([CL_DOUBLE_UNDERFLOW],
[
  AC_MSG_CHECKING([whether double-float underflow raises an exception])
  AC_CACHE_VAL(cl_cv_cc_double_underflow, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
#include <float.h>
static void sigfpe_handler (int sig) { exit (1); }
double x = DBL_MIN;
double y = DBL_MIN;
double z;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x * y;
  exit (0);
}
], cl_cv_cc_double_underflow=no, cl_cv_cc_double_underflow=yes,
   cl_cv_cc_double_underflow="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_double_underflow])
  if test "$cl_cv_cc_double_underflow" = yes; then
    AC_DEFINE(DOUBLE_UNDERFLOW_EXCEPTION,1,
      [Define to 1 if 'double' underflow raises an exception.])
  fi
])

AC_DEFUN([CL_LONGDOUBLE_UNDERFLOW],
[AC_REQUIRE([gt_TYPE_LONGDOUBLE])
if test "$gt_cv_c_long_double" = yes; then
  AC_MSG_CHECKING([whether long-float underflow raises an exception])
  AC_CACHE_VAL(cl_cv_cc_longdouble_underflow, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
#include <float.h>
static void sigfpe_handler (int sig) { exit (1); }
long double x;
long double y;
long double z;
int main ()
{
  x = LDBL_MIN;
  y = LDBL_MIN;
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x * y;
  exit (0);
}
], cl_cv_cc_longdouble_underflow=no, cl_cv_cc_longdouble_underflow=yes,
   cl_cv_cc_longdouble_underflow="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_longdouble_underflow])
  if test "$cl_cv_cc_longdouble_underflow" = yes; then
    AC_DEFINE(LONGDOUBLE_UNDERFLOW_EXCEPTION,1,
      [Define to 1 if 'long double' underflow raises an exception.])
  fi
fi
])


AC_DEFUN([CL_FLOAT_INEXACT],
[
  AC_MSG_CHECKING([whether single-float inexact raises an exception])
  AC_CACHE_VAL(cl_cv_cc_float_inexact, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
static void sigfpe_handler (int sig) { exit (1); }
float x = 1;
float y = 3;
float z;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x / y;
  exit (0);
}
], cl_cv_cc_float_inexact=no, cl_cv_cc_float_inexact=yes,
   cl_cv_cc_float_inexact="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_float_inexact])
  if test "$cl_cv_cc_float_inexact" = yes; then
    AC_DEFINE(FLOAT_INEXACT_EXCEPTION,1,
      [Define to 1 if a 'float' inexact operation raises an exception.])
  fi
])

AC_DEFUN([CL_DOUBLE_INEXACT],
[
  AC_MSG_CHECKING([whether double-float inexact raises an exception])
  AC_CACHE_VAL(cl_cv_cc_double_inexact, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
static void sigfpe_handler (int sig) { exit (1); }
double x = 1;
double y = 3;
double z;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x / y;
  exit (0);
}
], cl_cv_cc_double_inexact=no, cl_cv_cc_double_inexact=yes,
   cl_cv_cc_double_inexact="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_double_inexact])
  if test "$cl_cv_cc_double_inexact" = yes; then
    AC_DEFINE(DOUBLE_INEXACT_EXCEPTION,1,
      [Define to 1 if a 'double' inexact operation raises an exception.])
  fi
])

AC_DEFUN([CL_LONGDOUBLE_INEXACT],
[AC_REQUIRE([gt_TYPE_LONGDOUBLE])
if test "$gt_cv_c_long_double" = yes; then
  AC_MSG_CHECKING([whether long-float inexact raises an exception])
  AC_CACHE_VAL(cl_cv_cc_longdouble_inexact, [
    AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>
static void sigfpe_handler (int sig) { exit (1); }
long double x = 1;
long double y = 3;
long double z;
int main ()
{
  signal (SIGFPE, sigfpe_handler);
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
  z = x / y;
  exit (0);
}
], cl_cv_cc_longdouble_inexact=no, cl_cv_cc_longdouble_inexact=yes,
   cl_cv_cc_longdouble_inexact="guessing no")])
  AC_MSG_RESULT([$cl_cv_cc_longdouble_inexact])
  if test "$cl_cv_cc_longdouble_inexact" = yes; then
    AC_DEFINE(LONGDOUBLE_INEXACT_EXCEPTION,1,
      [Define to 1 if a 'long double' inexact operation raises an exception.])
  fi
fi
])
