.TH GROFF_MAN @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.
.SH NAME
.
groff_man \- groff `an' macros to support generation of man pages
.SH SYNOPSIS
.B groff
.B \-m@TMAC_AN_PREFIX@an
[
.IR options .\|.\|.
]
[
.IR files .\|.\|.
]
.
.SH DESCRIPTION
.
The 
.B tmac.an 
macros used to generate man pages with 
.I groff
were written by James Clark.  
This document provides a brief summary of the use of each macro in that
package.
.TP
.BI .TP " title section " [ extra1 "] [" extra2 "] [" extra3 ]
Sets the title of the man page to 
.I title
and the section to
.IR section ,
which must take on a value between 1 and\ 8.
The value
.I section
may also have a string appended, e.g. `.pm', to indicate a specific
subsection of the man pages.
.TP
.BI .SH " text for a heading"
Sets up an unindented and unnumbered section heading.
Prints out all the text following `.SH' up to the end of the line in bold
face, with a size slightly smaller than that for indented section headings.
.TP
.BI .SS " text for a heading"
Sets up an indented section heading.
Prints out all the text following `.SS' up to the end of the line in bold
face, with a size slightly larger than that for unindented section headings.
.TP
.BI ".TP [" nnn ]
Sets up an indented paragraph.
The indentation is set to 
.I nnn
if that argument is supplied.
The first line of text following this macro is interpreted as a string to be
printed flush-left, as it is appropriate for a label.
It is not interpreted as part of a paragraph, so there is no attempt to fill
the first line with text from the following input lines.
Nevertheless, if the label is not as wide as the indentation, then the
paragraph starts at the same line (but indented), continuing on the
following lines.
If the label is wider than the indentation, then the descriptive part of the
paragraph begins on the line following the label, entirely indented.
The `.TP' macro is the macro used for the explanations you are just reading.
.TP
.BR ".LP " or " .PP " or " .P"
These macros are mutual aliases.
Any of them causes a line break at the current position, followed by a
vertical space downwards by the amount that is set in the `PD' counter.
.TP
.BI ".IP [" designator "] [" nnn ]
Sets up an indented paragraph, using 
.I designator 
as a tag to mark its beginning.
The indentation is permanently set to
.I nnn
if that argument is supplied.
To set the indentation back to the previous level, one must call some other
macro that uses indented paragraphs, and explicitly provide it with the
value of the previous indentation.
.IP
For example, the following paragraphs were all set up with bullets as the
designator, using `.IP \\(bu 4':
.IP \(bu 4
`IP' is one of the three macros used in 
.B tmac.an
to format lists.
.IP \(bu 4
`HP' is another.
This macro produces a paragraph with a left hanging indentation.
.IP \(bu 4
`TP' is another.
This macro produces an unindented label (given by the text on the first line
following `TP'), followed by an indented paragraph with appropriately
descriptive text.
.TP
.BI ".HP [" nnn ]
Sets up paragraphs with hanging left indentation.
The indentation is set to
.I nnn
if that argument is supplied.
The following pargraph illustrates the effect of this macro with the hanging
indentation set to\ 2:
.HP 2
This is a pagraph following an invocation of the `.HP' macro.
As you can see, it produces a paragraph where all lines but the first are
flushed right and are shorter than the preceding lines.
.
.SH "MACROS TO SET FONTS"
.
.TP
.BI .SM 
Causes the text on the same line or the text on the next line to appear in a
font that is one point size smaller than the default font.
.TP
.BI .SB 
Causes the text on the same line or the text on the next line to appear in
small boldface font.
.TP
.BI ".BI " text
Causes text on the same line to appear alternately in bold face and italic.
The text must be on the same line as the macro call.
Thus `.BI this word and that' would cause `this' and `and' to appear in bold
face, while `word' and `that' appear in italics.
.TP
.BI ".IB " text
Causes text to appear alternately in italic and bold face.
The text must be on the same line as the macro call.
.TP
.BI ".BR " text
Causes text on the same line to appear alternately in bold face and roman.
The text must be on the same line as the macro call.
.TP
.BI ".RB " text
Causes text on the same line to appear alternately in roman and bold face.
The text must be on the same line as the macro call.
.TP
.BI ".R " text
Causes text to appear in roman font.
If no text is present on the line where the macro is called, then the text
of the next line appears in roman.
This is the default font to which text is returned at the end of processing
of the other macros.
.TP
.BI ".B " text
Causes text to appear in bold face.
If no text is present on the line where the macro is called, then the text
of the next line appears in bold face.
.TP
.BI ".I " text
Causes text to appear in italic.
If no text is present on the line where the macro is called, then the text
of the next line appears in italic.
.
.SH "SEE ALSO"
.
Since the 
.B tmac.an
macros consist of groups of 
.I groff 
requests, one can, in principle, supplement the functionality of the
.B tmac.an
macros with individual 
.I groff
requests where necessary.
A complete list of these requests is available on the WWW at
.ce 1
http://www.cs.pdx.edu/~trent/gnu/groff/groff_toc.html
.
.SH AUTHOR
.
This manual page was originally written for the Debian GNU/Linux system by
Susan G. Kleinmann <sgk@debian.org>, corrected by Werner Lemberg
<wl@gnu.org>, and is now part of the GNU troff distribution.
