/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.TableKeeper;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;

public class OPunary
extends OPfunction {
    protected int code;
    protected int uwrpCode = 0;
    protected int implCode = 0;
    protected int uwrpsTo = -1;
    protected static final byte[] unary_prmtns = (byte[])TableKeeper.getTable("unary_prmtns");
    private static final int[][] una = (int[][])TableKeeper.getTable("una");
    private static final String[] opSymbols = (String[])TableKeeper.getTable("opSymbols");
    private static final String[] opNames = (String[])TableKeeper.getTable("opNames");

    public OPunary(TypesStack typesStk, int code) throws CompilationException {
        Debug.assert(code >= 0 && code <= 3);
        this.code = code;
        int opID = typesStk.peekID();
        Class opType = typesStk.pop();
        if (code == 3) {
            this.resID = TypesStack.baseType[opID];
            this.implCode = una[code][this.resID];
        } else {
            int unwrpID = TypesStack.unwrapType[opID];
            if (unwrpID != opID) {
                this.uwrpCode = (opID - 12 + 11 << 8) + 254;
                this.uwrpsTo = unwrpID;
            }
            if ((this.implCode = una[code][unwrpID]) == 255) {
                Object[] paramsExc = new Object[]{opNames[code], opType};
                throw new CompilationException(-1, 28, paramsExc);
            }
            this.resID = unary_prmtns[unwrpID];
            typesStk.pushID(this.resID, null);
        }
    }

    public OPunary(TypesStack typesStk, int targetID, Class targetClass, boolean allownarrowing) throws CompilationException {
        Debug.assert(targetID != 8 || targetClass != null);
        this.resID = targetID;
        this.resType = targetClass != null ? targetClass : TypesStack.specialTypes[targetID];
        Class currClass = typesStk.peek();
        int currID = typesStk.peekID();
        int unwrappedCurrID = TypesStack.unwrapType[currID];
        if (this.resID == 10) {
            this.code = 4 + this.resID;
            if (currID == 28) {
                unwrappedCurrID = 8;
            }
        } else {
            this.code = this.resID == 11 ? 4 + this.resID : 4 + TypesStack.baseType[this.resID];
            if (unwrappedCurrID != currID) {
                this.uwrpCode = (currID - 12 + 11 << 8) + 254;
                this.uwrpsTo = unwrappedCurrID;
            }
        }
        if ((this.implCode = una[this.code][unwrappedCurrID]) == 255) {
            Object[] paramsExc = new Object[]{currClass, this.resType};
            throw new CompilationException(-1, 21, paramsExc);
        }
        if (!allownarrowing && !TypesStack.isWidening(currID, currClass, this.resID, this.resType)) {
            Object[] paramsExc = new Object[]{currClass, this.resType};
            throw new CompilationException(-1, 22, paramsExc);
        }
        typesStk.pop();
        typesStk.pushID(this.resID, this.resType);
    }

    public int getNParams() {
        return 1;
    }

    protected void compile_pre(ClassFile cf) {
        if (this.code == 2) {
            cf.code(251L);
        }
        if (this.code == 14) {
            cf.code(2191928458683L);
            cf.typesStk.pushID(10);
        }
    }

    protected void compile(ClassFile cf) {
        cf.code(this.uwrpCode);
        if (this.uwrpsTo >= 0) {
            cf.typesStk.pop();
            cf.typesStk.pushID(this.uwrpsTo);
        }
        cf.code(this.implCode);
        if (this.code == 12) {
            cf.codeI(cf.getIndex(this.resType, 9));
        }
        switch (this.code) {
            case 2: 
            case 4: {
                break;
            }
            case 3: 
            case 13: {
                cf.typesStk.pop();
                break;
            }
            case 1: {
                cf.typesStk.tempExcessWords(TypesStack.stkoccup[this.resID]);
            }
            default: {
                cf.typesStk.pop();
                cf.typesStk.pushID(this.resID, this.resType);
            }
        }
    }

    protected void eval(OPlist list) {
        if (!(this.prev instanceof OPload)) {
            return;
        }
        if (this.code == 3) {
            return;
        }
        if (this.code == 13) {
            return;
        }
        if (this.code == 12) {
            return;
        }
        OPload opl = (OPload)this.prev;
        if (this.code == 2) {
            opl.what = ((Boolean)opl.what).booleanValue() ? Boolean.FALSE : Boolean.TRUE;
        } else if (this.code < 2) {
            Number val = TypesStack.widen(opl.what, opl.resID);
            switch (this.code) {
                case 0: {
                    if (opl.resID > 5) {
                        val = new Double(-val.doubleValue());
                        break;
                    }
                    val = new Long(-val.longValue());
                    break;
                }
                case 1: {
                    val = new Long(val.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                default: {
                    Debug.assert(this.code >= 0, "Wrong unary opcode.");
                }
            }
            opl.what = TypesStack.narrow(val, this.resID);
            opl.resID = this.resID;
        } else {
            opl.what = this.code == 14 ? new StringBuffer(String.valueOf(opl.what)) : (this.code == 15 ? opl.what.toString() : TypesStack.narrow(TypesStack.widen(opl.what, opl.resID), this.resID));
            opl.resID = this.resID;
        }
        list.remove(this);
    }

    public String toString() {
        return opSymbols[this.code];
    }

    static {
        Debug.assert(opNames.length == opSymbols.length && opNames.length == una.length);
    }
}

