/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import java.io.DataOutputStream;
import java.io.IOException;

public class CpoolClass
extends CpoolEntry {
    CpoolUtf8 name;
    ObjectType clas;

    CpoolClass() {
    }

    CpoolClass(ConstantPool constantPool, int n, CpoolUtf8 cpoolUtf8) {
        super(constantPool, n);
        this.name = cpoolUtf8;
    }

    public int getTag() {
        return 7;
    }

    public final CpoolUtf8 getName() {
        return this.name;
    }

    public final String getStringName() {
        return this.name.string;
    }

    public final String getClassName() {
        return this.name.string.replace('/', '.');
    }

    public final ObjectType getClassType() {
        ObjectType objectType = this.clas;
        if (objectType != null) {
            return objectType;
        }
        String string = this.name.string;
        objectType = string.charAt(0) == '[' ? (ObjectType)Type.signatureToType(string) : ClassType.make(string.replace('/', '.'));
        this.clas = objectType;
        return objectType;
    }

    static final int hashCode(CpoolUtf8 cpoolUtf8) {
        return cpoolUtf8.hashCode() ^ 0xF0F;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = CpoolClass.hashCode(this.name);
        }
        return this.hash;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(7);
        dataOutputStream.writeShort(this.name.index);
    }

    public void print(ClassTypeWriter classTypeWriter, int n) {
        if (n == 1) {
            classTypeWriter.print("Class ");
        } else if (n > 1) {
            classTypeWriter.print("Class name: ");
            classTypeWriter.printOptionalIndex(this.name);
        }
        String string = this.name.string;
        int n2 = string.length();
        if (n2 > 1 && string.charAt(0) == '[') {
            Type.printSignature(string, 0, n2, classTypeWriter);
        } else {
            classTypeWriter.print(string.replace('/', '.'));
        }
    }
}

