/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.KawaScriptEngine;
import gnu.expr.Language;
import gnu.kawa.util.WeakIdentityHashMap;
import gnu.mapping.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import kawa.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptEngineFactory
implements ScriptEngineFactory {
    Language language;
    private List<String> extensions;
    protected List<String> names;
    private static List<String> noMimeTypes;
    WeakIdentityHashMap<Bindings, Environment> contextMap = new WeakIdentityHashMap();

    void setEnvironment(Bindings bindings, Environment environment) {
        this.contextMap.put(bindings, environment);
    }

    Environment getEnvironment(ScriptContext scriptContext) {
        return this.getEnvironment(scriptContext.getBindings(100));
    }

    Environment getEnvironment(Bindings bindings) {
        Environment environment = (Environment)this.contextMap.get(bindings);
        if (environment == null) {
            throw new UnsupportedOperationException("Bindings must be created using createBindings");
        }
        return environment;
    }

    protected AbstractScriptEngineFactory(Language language) {
        this.language = language;
    }

    @Override
    public String getEngineName() {
        return "Kawa-" + this.language.getName();
    }

    @Override
    public String getEngineVersion() {
        return Version.getVersion();
    }

    @Override
    public String getLanguageVersion() {
        return Version.getVersion();
    }

    @Override
    public String getLanguageName() {
        return this.language.getName();
    }

    @Override
    public List<String> getExtensions() {
        if (this.extensions == null) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            String[][] stringArray = Language.getLanguages();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                if (stringArray2 == null) continue;
                int n = stringArray2.length - 1;
                String string = stringArray2[n];
                if (!this.language.getName().equals(string)) continue;
                for (int j = 1; j < n; ++j) {
                    String string2 = stringArray2[j];
                    if (string2 == null || string2.charAt(0) != '.') continue;
                    arrayList.add(string2.substring(1));
                }
            }
            this.extensions = Collections.unmodifiableList(arrayList);
        }
        return this.extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        if (noMimeTypes == null) {
            noMimeTypes = Collections.unmodifiableList(new ArrayList(0));
        }
        return noMimeTypes;
    }

    @Override
    public List<String> getNames() {
        if (this.names == null) {
            ArrayList<String> arrayList = new ArrayList<String>(3);
            this.getNames(arrayList);
            this.names = Collections.unmodifiableList(arrayList);
        }
        return this.names;
    }

    protected void getNames(List<String> list) {
        list.add(this.language.getName());
    }

    @Override
    public String getMethodCallSyntax(String string, String string2, String ... stringArray) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getMethodCalSyntax not supported");
    }

    @Override
    public String getOutputStatement(String string) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getOutputStatement not supported");
    }

    @Override
    public String getProgram(String ... stringArray) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getProgram not supported");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new KawaScriptEngine(this);
    }

    @Override
    public String getParameter(String string) {
        if (string.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (string.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (string.equals("javax.script.name")) {
            return this.getEngineName();
        }
        if (string.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (string.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (string.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }
}

