/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Location;
import gnu.mapping.LocationRef;
import gnu.mapping.Named;
import gnu.mapping.NamedLocation;
import gnu.mapping.SharedLocation;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;

public class ThreadLocation
extends Location
implements Named {
    final Symbol name;
    final Object property;
    static int counter;
    boolean unlink;
    public static final String ANONYMOUS;
    Location global;
    ThreadLocal thLocal = new ThreadLocal();
    static SimpleEnvironment env;

    private static synchronized int nextCounter() {
        return ++counter;
    }

    public ThreadLocation() {
        this("param#" + ThreadLocation.nextCounter());
    }

    public ThreadLocation(String string) {
        this.name = Symbol.makeUninterned(string);
        this.property = ANONYMOUS;
        this.unlink = true;
        this.global = new SharedLocation(this.name, null, 0);
    }

    private ThreadLocation(Symbol symbol) {
        this.name = symbol;
        String string = symbol == null ? null : symbol.toString();
        this.property = ANONYMOUS;
        this.unlink = true;
        this.global = new SharedLocation(Symbol.makeUninterned(string), null, 0);
    }

    public ThreadLocation(Symbol symbol, Object object2, Location location2) {
        this.name = symbol;
        this.property = object2;
        this.global = location2;
    }

    public static ThreadLocation makePrivate(String string) {
        return new ThreadLocation(string);
    }

    public static ThreadLocation makePrivate(Symbol symbol) {
        return new ThreadLocation(symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobal(Object object2) {
        ThreadLocation threadLocation = this;
        synchronized (threadLocation) {
            if (this.global == null) {
                this.global = new SharedLocation(this.name, null, 0);
            }
            this.global.set(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation() {
        Object object2 = this.thLocal.get();
        if (object2 == null) {
            Object object3;
            Environment environment = Environment.getCurrent();
            NamedLocation namedLocation = environment.getLocation(this.name, this.property, true);
            if (this.global != null) {
                object3 = namedLocation;
                synchronized (object3) {
                    if (namedLocation.base == null && namedLocation.value == Location.UNBOUND) {
                        namedLocation.setBase(this.global);
                    }
                }
            }
            if (this.unlink) {
                object3 = new LocationRef();
                ((LocationRef)object3).env = environment;
                ((LocationRef)object3).loc = namedLocation;
                object2 = object3;
            } else {
                object2 = namedLocation;
            }
            this.thLocal.set(object2);
        }
        if (object2 instanceof LocationRef) {
            return ((LocationRef)object2).loc;
        }
        return (Location)object2;
    }

    public Object get(Object object2) {
        return this.getLocation().get(object2);
    }

    public void set(Object object2) {
        this.getLocation().set(object2);
    }

    public Object setWithSave(Object object2, CallContext callContext) {
        return this.getLocation().setWithSave(object2, callContext);
    }

    public void setRestore(Object object2, CallContext callContext) {
        this.getLocation().setRestore(object2, callContext);
    }

    public Symbol getKeySymbol() {
        return this.name;
    }

    public Object getKeyProperty() {
        return this.property;
    }

    public String getName() {
        return this.name == null ? null : this.name.toString();
    }

    public Object getSymbol() {
        if (this.name != null && this.property == ANONYMOUS && ((SharedLocation)this.global).getKeySymbol() == this.name) {
            return this.name.toString();
        }
        return this.name;
    }

    public void setName(String string) {
        throw new RuntimeException("setName not allowed");
    }

    public static synchronized ThreadLocation getInstance(Symbol symbol, Object object2) {
        if (env == null) {
            env = new SimpleEnvironment("[thread-locations]");
        }
        IndirectableLocation indirectableLocation = (IndirectableLocation)env.getLocation(symbol, object2);
        if (indirectableLocation.base != null) {
            return (ThreadLocation)indirectableLocation.base;
        }
        ThreadLocation threadLocation = new ThreadLocation(symbol, object2, null);
        indirectableLocation.base = threadLocation;
        return threadLocation;
    }

    static {
        ANONYMOUS = new String("(dynamic)");
    }
}

