/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.FString;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongType;
import gnu.text.FilePath;
import gnu.text.URIPath;
import gnu.text.URLPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public abstract class Path {
    public static final FilePath userDirPath = FilePath.valueOf(new File("."));
    public static Path defaultPath = userDirPath;
    private static ThreadLocal pathLocation = new ThreadLocal();

    protected Path() {
    }

    public static Path currentPath() {
        Object t = pathLocation.get();
        if (t != null) {
            return (Path)t;
        }
        return defaultPath;
    }

    public static void setCurrentPath(Path path) {
        pathLocation.set(path);
    }

    public static Path coerceToPathOrNull(Object object2) {
        String string;
        if (object2 instanceof Path) {
            return (Path)object2;
        }
        if (object2 instanceof URL) {
            return URLPath.valueOf((URL)object2);
        }
        if (object2 instanceof URI) {
            return URIPath.valueOf((URI)object2);
        }
        if (object2 instanceof File) {
            return FilePath.valueOf((File)object2);
        }
        if (object2 instanceof FString) {
            string = object2.toString();
        } else {
            if (!(object2 instanceof String)) {
                return null;
            }
            string = (String)object2;
        }
        if (Path.uriSchemeSpecified(string)) {
            return URIPath.valueOf(string);
        }
        return FilePath.valueOf(string);
    }

    public static Path valueOf(Object object2) {
        Path path = Path.coerceToPathOrNull(object2);
        if (path == null) {
            throw new WrongType((String)null, -4, object2, "path");
        }
        return path;
    }

    public static URL toURL(String string) {
        try {
            if (!Path.uriSchemeSpecified(string)) {
                Path path = Path.currentPath();
                Path path2 = path.resolve(string);
                if (path2.isAbsolute()) {
                    return path2.toURL();
                }
                string = path2.toString();
            }
            return new URL(string);
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    public static int uriSchemeLength(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return i;
            }
            if (!(i == 0 ? !Character.isLetter(c) : !Character.isLetterOrDigit(c) && c != '+' && c != '-' && c != '.')) continue;
            return -1;
        }
        return -1;
    }

    public static boolean uriSchemeSpecified(String string) {
        int n = Path.uriSchemeLength(string);
        if (n == 1 && File.separatorChar == '\\') {
            char c = string.charAt(0);
            return !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
        }
        return n > 0;
    }

    public abstract boolean isAbsolute();

    public boolean isDirectory() {
        char c;
        String string = this.toString();
        int n = string.length();
        return n > 0 && ((c = string.charAt(n - 1)) == '/' || c == File.separatorChar);
    }

    public boolean delete() {
        return false;
    }

    public boolean exists() {
        return this.getLastModified() != 0L;
    }

    public abstract long getLastModified();

    public long getContentLength() {
        return -1L;
    }

    public abstract String getScheme();

    public String getAuthority() {
        return null;
    }

    public String getUserInfo() {
        return null;
    }

    public String getHost() {
        return null;
    }

    public abstract String getPath();

    public Path getDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        return this.resolve("");
    }

    public Path getParent() {
        return this.resolve(this.isDirectory() ? ".." : "");
    }

    public String getLast() {
        int n;
        String string = this.getPath();
        if (string == null) {
            return null;
        }
        int n2 = n = string.length();
        int n3 = n;
        while (true) {
            if (--n3 <= 0) {
                return "";
            }
            char c = string.charAt(n3);
            if (c != '/' && (!(this instanceof FilePath) || c != File.separatorChar)) continue;
            if (n3 + 1 != n) break;
            n2 = n3;
        }
        return string.substring(n3 + 1, n2);
    }

    public String getExtension() {
        boolean bl;
        int n;
        String string = this.getPath();
        if (string == null) {
            return null;
        }
        int n2 = n = string.length();
        do {
            if (--n2 <= 0) {
                return null;
            }
            char c = string.charAt(n2);
            bl = false;
            if (c == '.') {
                c = string.charAt(n2 - 1);
                bl = true;
            }
            if (c != '/' && (!(this instanceof FilePath) || c != File.separatorChar)) continue;
            return null;
        } while (!bl);
        return string.substring(n2 + 1);
    }

    public int getPort() {
        return -1;
    }

    public String getQuery() {
        return null;
    }

    public String getFragment() {
        return null;
    }

    public abstract URL toURL();

    public abstract URI toUri();

    public final URI toURI() {
        return this.toUri();
    }

    public String toURIString() {
        return this.toUri().toString();
    }

    public Path resolve(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return this.resolve(path.toString());
    }

    public abstract Path resolve(String var1);

    public static InputStream openInputStream(Object object2) throws IOException {
        return Path.valueOf(object2).openInputStream();
    }

    public abstract InputStream openInputStream() throws IOException;

    public abstract OutputStream openOutputStream() throws IOException;

    public Reader openReader(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream());
    }

    public CharSequence getCharContent(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static String relativize(String string, String string2) throws URISyntaxException, IOException {
        char c;
        char c2;
        int n;
        String string3 = string2;
        String string4 = string;
        string3 = new URI(string3).normalize().toString();
        string4 = URLPath.valueOf(string).toURI().normalize().toString();
        int n2 = string3.length();
        int n3 = string4.length();
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2 && n < n3 && (c2 = string3.charAt(n)) == (c = string4.charAt(n)); ++n) {
            if (c2 == '/') {
                n4 = n;
            }
            if (c2 != ':') continue;
            n5 = n;
        }
        if (n5 <= 0 || n4 <= n5 + 2 && n2 > n5 + 2 && string3.charAt(n5 + 2) == '/') {
            return string;
        }
        string3 = string3.substring(n4 + 1);
        string4 = string4.substring(n4 + 1);
        StringBuilder stringBuilder = new StringBuilder();
        n4 = 0;
        n = n2 = string3.length();
        while (--n >= 0) {
            if (string3.charAt(n) != '/') continue;
            stringBuilder.append("../");
        }
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    public String getName() {
        return this.toString();
    }

    public Path getAbsolute() {
        if (this == userDirPath) {
            return this.resolve("");
        }
        return Path.currentPath().resolve(this);
    }

    public Path getCanonical() {
        return this.getAbsolute();
    }
}

