/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.kawa.xml.KNode;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XTimeType;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.math.DateTime;
import gnu.math.Duration;
import gnu.math.IntNum;
import gnu.xml.TextUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.TimeZone;

public class TimeUtils {
    static final ThreadLocal<DateTime> currentDateTimeLocal = new ThreadLocal();

    static DateTime coerceToDateTime(String string, Object object2) {
        if (XTimeType.dateTimeType.isInstance(object2)) {
            return (DateTime)object2;
        }
        if (object2 instanceof KNode || object2 instanceof UntypedAtomic) {
            return XTimeType.parseDateTime(TextUtils.stringValue(object2), 126);
        }
        throw new WrongType(string, 1, object2, "xs:dateTime");
    }

    static DateTime coerceToDate(String string, Object object2) {
        if (XTimeType.dateType.isInstance(object2)) {
            return (DateTime)object2;
        }
        if (object2 instanceof KNode || object2 instanceof UntypedAtomic) {
            return XTimeType.parseDateTime(TextUtils.stringValue(object2), 14);
        }
        throw new WrongType(string, 1, object2, "xs:date");
    }

    static DateTime coerceToTime(String string, Object object2) {
        if (XTimeType.timeType.isInstance(object2)) {
            return (DateTime)object2;
        }
        if (object2 instanceof KNode || object2 instanceof UntypedAtomic) {
            return XTimeType.parseDateTime(TextUtils.stringValue(object2), 112);
        }
        throw new WrongType(string, 1, object2, "xs:time");
    }

    static Duration coerceToDuration(String string, Object object2) {
        if (object2 instanceof Duration) {
            return (Duration)object2;
        }
        throw new WrongType(string, 1, object2, "xs:duration");
    }

    static Object timeZoneFromXTime(DateTime dateTime) {
        if (dateTime.isZoneUnspecified()) {
            return Values.empty;
        }
        return Duration.makeMinutes(dateTime.getZoneMinutes());
    }

    static IntNum asInteger(int n) {
        return IntNum.make(n);
    }

    public static Object yearFromDateTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDateTime("year-from-dateTime", object2).getYear());
    }

    public static Object monthFromDateTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDateTime("month-from-dateTime", object2).getMonth());
    }

    public static Object dayFromDateTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDateTime("day-from-dateTime", object2).getDay());
    }

    public static Object hoursFromDateTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDateTime("hours-from-dateTime", object2).getHours());
    }

    public static Object minutesFromDateTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDateTime("minutes-from-dateTime", object2).getMinutes());
    }

    static Number getSeconds(DateTime dateTime) {
        int n = dateTime.getSecondsOnly();
        long l = dateTime.getNanoSecondsOnly();
        if (l == 0L) {
            return IntNum.make(n);
        }
        return new BigDecimal(BigInteger.valueOf(l += (long)n * 1000000000L), 9);
    }

    public static Object secondsFromDateTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.getSeconds(TimeUtils.coerceToDateTime("seconds-from-dateTime", object2));
    }

    public static Object timezoneFromDateTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.timeZoneFromXTime(TimeUtils.coerceToDateTime("timezone-from-datetime", object2));
    }

    public static Object yearFromDate(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDate("year-from-date", object2).getYear());
    }

    public static Object monthFromDate(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDate("month-from-date", object2).getMonth());
    }

    public static Object dayFromDate(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDate("day-from-date", object2).getDay());
    }

    public static Object timezoneFromDate(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.timeZoneFromXTime(TimeUtils.coerceToDate("timezone-from-date", object2));
    }

    public static Object hoursFromTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToTime("hours-from-time", object2).getHours());
    }

    public static Object minutesFromTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToTime("minutes-from-time", object2).getMinutes());
    }

    public static Object secondsFromTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.getSeconds(TimeUtils.coerceToTime("seconds-from-time", object2));
    }

    public static Object timezoneFromTime(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.timeZoneFromXTime(TimeUtils.coerceToTime("timezone-from-time", object2));
    }

    public static Object yearsFromDuration(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDuration("years-from-duration", object2).getYears());
    }

    public static Object monthsFromDuration(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDuration("months-from-duration", object2).getMonths());
    }

    public static Object daysFromDuration(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDuration("days-from-duration", object2).getDays());
    }

    public static Object hoursFromDuration(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDuration("hours-from-duration", object2).getHours());
    }

    public static Object minutesFromDuration(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        return TimeUtils.asInteger(TimeUtils.coerceToDuration("minutes-from-duration", object2).getMinutes());
    }

    public static BigDecimal secondsBigDecimalFromDuration(long l, int n) {
        long l2;
        if (n == 0) {
            return BigDecimal.valueOf(l);
        }
        int n2 = 9;
        boolean bl = (long)((int)l) != l;
        long l3 = l2 = bl ? (long)n : l * 1000000000L + (long)n;
        while (l2 % 10L == 0L) {
            l2 /= 10L;
            --n2;
        }
        BigDecimal bigDecimal = new BigDecimal(BigInteger.valueOf(l2), n2);
        if (bl) {
            bigDecimal = BigDecimal.valueOf(l).add(bigDecimal);
        }
        return bigDecimal;
    }

    public static Object secondsFromDuration(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        Duration duration = TimeUtils.coerceToDuration("seconds-from-duration", object2);
        int n = duration.getSecondsOnly();
        int n2 = duration.getNanoSecondsOnly();
        if (n2 == 0) {
            return TimeUtils.asInteger(n);
        }
        return TimeUtils.secondsBigDecimalFromDuration(n, n2);
    }

    public static Duration getImplicitTimezone() {
        return Duration.makeMinutes(TimeZone.getDefault().getRawOffset() / 60000);
    }

    public static Object adjustDateTimeToTimezone(Object object2) {
        return TimeUtils.adjustDateTimeToTimezone(object2, TimeUtils.getImplicitTimezone());
    }

    public static Object adjustDateTimeToTimezone(Object object2, Object object3) {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        DateTime dateTime = TimeUtils.coerceToDateTime("adjust-dateTime-to-timezone", object2);
        return TimeUtils.adjustDateTimeToTimezoneRaw(dateTime, object3);
    }

    public static Object adjustDateToTimezone(Object object2) {
        return TimeUtils.adjustDateToTimezone(object2, TimeUtils.getImplicitTimezone());
    }

    public static Object adjustDateToTimezone(Object object2, Object object3) {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        DateTime dateTime = TimeUtils.coerceToDate("adjust-date-to-timezone", object2);
        return TimeUtils.adjustDateTimeToTimezoneRaw(dateTime, object3);
    }

    public static Object adjustTimeToTimezone(Object object2) {
        return TimeUtils.adjustTimeToTimezone(object2, TimeUtils.getImplicitTimezone());
    }

    public static Object adjustTimeToTimezone(Object object2, Object object3) {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        DateTime dateTime = TimeUtils.coerceToTime("adjust-time-to-timezone", object2);
        return TimeUtils.adjustDateTimeToTimezoneRaw(dateTime, object3);
    }

    static Object adjustDateTimeToTimezoneRaw(DateTime dateTime, Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return dateTime.withZoneUnspecified();
        }
        Duration duration = (Duration)object2;
        if (duration.getNanoSecondsOnly() != 0 || duration.getSecondsOnly() != 0) {
            throw new IllegalArgumentException("timezone offset with fractional minute");
        }
        int n = (int)duration.getTotalMinutes();
        if (n < -840 || n > 840) {
            throw new IllegalArgumentException("timezone offset out of range");
        }
        return dateTime.adjustTimezone(n);
    }

    public static DateTime now() {
        return XTimeType.dateTimeType.now();
    }

    public static Object dateTime(Object object2, Object object3) {
        boolean bl;
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        if (object3 == null || object3 == Values.empty) {
            return object3;
        }
        DateTime dateTime = TimeUtils.coerceToDate("dateTime", object2);
        DateTime dateTime2 = TimeUtils.coerceToTime("dateTime", object3);
        StringBuffer stringBuffer = new StringBuffer();
        dateTime.toStringDate(stringBuffer);
        stringBuffer.append('T');
        dateTime2.toStringTime(stringBuffer);
        boolean bl2 = !dateTime.isZoneUnspecified();
        boolean bl3 = bl = !dateTime2.isZoneUnspecified();
        if (bl2 || bl) {
            int n = dateTime.getZoneMinutes();
            int n2 = dateTime2.getZoneMinutes();
            if (bl2 && bl && n != n2) {
                throw new Error("dateTime: incompatible timezone in arguments");
            }
            DateTime.toStringZone(bl2 ? n : n2, stringBuffer);
        }
        return (DateTime)XTimeType.dateTimeType.valueOf(stringBuffer.toString());
    }

    public static DateTime currentDateTime() {
        DateTime dateTime = currentDateTimeLocal.get();
        if (dateTime == null) {
            dateTime = TimeUtils.now();
            currentDateTimeLocal.set(dateTime);
        }
        return dateTime;
    }

    public static DateTime currentDate() {
        return TimeUtils.currentDateTime().cast(14);
    }

    public static DateTime currentTime() {
        return TimeUtils.currentDateTime().cast(112);
    }

    public static Object implicitTimezone() {
        return TimeUtils.timeZoneFromXTime(TimeUtils.currentDateTime());
    }
}

